/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.base.Strings;
import io.confluent.ksql.execution.expression.tree.DecimalLiteral;
import io.confluent.ksql.execution.expression.tree.DoubleLiteral;
import io.confluent.ksql.execution.expression.tree.IntegerLiteral;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.execution.expression.tree.LongLiteral;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.CaseInsensitiveStream;
import io.confluent.ksql.parser.NodeLocation;
import io.confluent.ksql.parser.ParsingException;
import io.confluent.ksql.parser.SqlBaseLexer;
import io.confluent.ksql.parser.SqlBaseParser;
import io.confluent.ksql.parser.exception.ParseFailedException;
import io.confluent.ksql.parser.tree.ColumnConstraints;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.ParserKeywordValidatorUtil;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.text.translate.LookupTranslator;

public final class ParserUtil {
    private static final Pattern VALID_SOURCE_NAMES = Pattern.compile("[a-zA-Z0-9_-]*");
    private static final LookupTranslator ESCAPE_SYMBOLS = new LookupTranslator((CharSequence[][])new String[][]{{"'", "''"}});

    private ParserUtil() {
    }

    public static SourceName getSourceName(SqlBaseParser.SourceNameContext sourceName) {
        String text = ParserUtil.getIdentifierText(sourceName.identifier());
        if (!VALID_SOURCE_NAMES.matcher(text).matches()) {
            throw new ParseFailedException("Illegal argument at " + ParserUtil.getLocation(sourceName).map(NodeLocation::toString).orElse("?") + ". Source names may only contain alphanumeric values, '_' or '-'. Got: '" + text + "'");
        }
        return SourceName.of((String)text);
    }

    public static String getIdentifierText(SqlBaseParser.IdentifierContext context) {
        return ParserUtil.getIdentifierText(false, context);
    }

    public static String getIdentifierText(boolean caseSensitive, SqlBaseParser.IdentifierContext context) {
        if (context instanceof SqlBaseParser.QuotedIdentifierAlternativeContext) {
            return ParserUtil.unquote(context.getText(), "\"");
        }
        if (context instanceof SqlBaseParser.BackQuotedIdentifierContext) {
            return ParserUtil.unquote(context.getText(), "`");
        }
        return caseSensitive ? context.getText() : context.getText().toUpperCase();
    }

    public static String unquote(String value, String quote) {
        return value.substring(1, value.length() - 1).replace(quote + quote, quote);
    }

    public static boolean isQuoted(String value, String quote) {
        return value.startsWith(quote) && value.endsWith(quote);
    }

    public static String sanitize(String value) {
        if (ParserUtil.isQuoted(value, "'")) {
            return "'" + ParserUtil.escapeString(ParserUtil.unquote(value, "'")) + "'";
        }
        return ParserUtil.escapeString(value);
    }

    private static String escapeString(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return ESCAPE_SYMBOLS.translate((CharSequence)value);
    }

    private static String validateAndUnquote(String value, char quote) {
        if (value.charAt(0) != quote) {
            throw new IllegalStateException("Value must begin with quote");
        }
        if (value.charAt(value.length() - 1) != quote || value.length() < 2) {
            throw new IllegalArgumentException("Expected matching quote at end of value");
        }
        int i = 1;
        while (i < value.length() - 1) {
            if (value.charAt(i) == quote) {
                if (value.charAt(i + 1) != quote || i + 1 == value.length() - 1) {
                    throw new IllegalArgumentException("Un-escaped quote in middle of value at index " + i);
                }
                i += 2;
                continue;
            }
            ++i;
        }
        return value.substring(1, value.length() - 1).replace("" + quote + quote, "" + quote);
    }

    public static int processIntegerNumber(SqlBaseParser.NumberContext number, String context) {
        if (number instanceof SqlBaseParser.IntegerLiteralContext) {
            return ((IntegerLiteral)ParserUtil.visitIntegerLiteral((SqlBaseParser.IntegerLiteralContext)number)).getValue();
        }
        throw new KsqlException("Value must be integer for command: " + context);
    }

    public static Literal visitIntegerLiteral(SqlBaseParser.IntegerLiteralContext context) {
        long valueAsLong;
        Optional<NodeLocation> location = ParserUtil.getLocation(context);
        try {
            valueAsLong = Long.parseLong(context.getText());
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Invalid numeric literal: " + context.getText(), location);
        }
        if (valueAsLong <= Integer.MAX_VALUE && valueAsLong >= Integer.MIN_VALUE) {
            return new IntegerLiteral(location, (int)valueAsLong);
        }
        return new LongLiteral(location, valueAsLong);
    }

    public static DoubleLiteral parseFloatLiteral(SqlBaseParser.FloatLiteralContext context) {
        Optional<NodeLocation> location = ParserUtil.getLocation(context);
        try {
            double value = Double.parseDouble(context.getText());
            if (Double.isNaN(value)) {
                throw new ParsingException("Not a number: " + context.getText(), location);
            }
            if (Double.isInfinite(value)) {
                throw new ParsingException("Number overflows DOUBLE: " + context.getText(), location);
            }
            return new DoubleLiteral(location, value);
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Invalid numeric literal: " + context.getText(), location);
        }
    }

    public static DecimalLiteral parseDecimalLiteral(SqlBaseParser.DecimalLiteralContext context) {
        Optional<NodeLocation> location = ParserUtil.getLocation(context);
        try {
            String value = context.getText();
            return new DecimalLiteral(location, new BigDecimal(value));
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Invalid numeric literal: " + context.getText(), location);
        }
    }

    public static Optional<NodeLocation> getLocation(TerminalNode terminalNode) {
        Objects.requireNonNull(terminalNode, "terminalNode is null");
        return ParserUtil.getLocation(terminalNode.getSymbol());
    }

    public static Optional<NodeLocation> getLocation(ParserRuleContext parserRuleContext) {
        Objects.requireNonNull(parserRuleContext, "parserRuleContext is null");
        return ParserUtil.getLocation(parserRuleContext.getStart());
    }

    public static Optional<NodeLocation> getLocation(Token token) {
        Objects.requireNonNull(token, "token is null");
        return Optional.of(new NodeLocation(token.getLine(), token.getCharPositionInLine()));
    }

    public static boolean isReserved(String token) {
        SqlBaseLexer sqlBaseLexer = new SqlBaseLexer(new CaseInsensitiveStream((CharStream)CharStreams.fromString((String)token)));
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)sqlBaseLexer);
        SqlBaseParser sqlBaseParser = new SqlBaseParser((TokenStream)tokenStream);
        sqlBaseParser.removeErrorListeners();
        SqlBaseParser.NonReservedContext nonReservedContext = sqlBaseParser.nonReserved();
        if (nonReservedContext.exception == null) {
            return false;
        }
        Set<String> allVocab = ParserKeywordValidatorUtil.getKsqlReservedWords();
        return allVocab.contains(token.toLowerCase());
    }

    public static ColumnConstraints getColumnConstraints(SqlBaseParser.ColumnConstraintsContext context) {
        if (context == null) {
            return ColumnConstraints.NO_COLUMN_CONSTRAINTS;
        }
        ColumnConstraints.Builder builder = new ColumnConstraints.Builder();
        if (context.KEY() != null) {
            builder = context.PRIMARY() != null ? builder.primaryKey() : builder.key();
        } else if (context.HEADERS() != null) {
            builder = builder.headers();
        } else if (context.HEADER() != null) {
            builder = builder.header(Strings.emptyToNull((String)ParserUtil.unquote(context.STRING().getText(), "'").trim()));
        }
        return builder.build();
    }
}

