/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.KsqlWarning;
import io.confluent.ksql.rest.entity.SourceDescription;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectorDescription
extends KsqlEntity {
    private final String connectorClass;
    private final ConnectorStateInfo status;
    private final List<SourceDescription> sources;
    private final List<String> topics;

    @JsonCreator
    public ConnectorDescription(@JsonProperty(value="statementText") String statementText, @JsonProperty(value="connectorClass") String connectorClass, @JsonProperty(value="status") ConnectorStateInfo status, @JsonProperty(value="sources") List<SourceDescription> sources, @JsonProperty(value="topics") List<String> topics, @JsonProperty(value="warnings") List<KsqlWarning> warnings) {
        super(statementText, warnings);
        this.connectorClass = Objects.requireNonNull(connectorClass, "connectorClass");
        this.status = Objects.requireNonNull(status, "status");
        this.sources = Objects.requireNonNull(sources, "sources");
        this.topics = Objects.requireNonNull(topics, "topics");
    }

    public String getConnectorClass() {
        return this.connectorClass;
    }

    public ConnectorStateInfo getStatus() {
        return this.status;
    }

    public List<SourceDescription> getSources() {
        return this.sources;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorDescription that = (ConnectorDescription)o;
        return Objects.equals(this.status, that.status) && Objects.equals(this.connectorClass, that.connectorClass) && Objects.equals(this.sources, that.sources) && Objects.equals(this.topics, that.topics);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.sources, this.connectorClass, this.topics);
    }

    public String toString() {
        return "ConnectorDescription{status=" + this.status + ", sources=" + this.sources + ", connectorClass='" + this.connectorClass + "', topics='" + this.topics + "'" + '}';
    }
}

