/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.KsqlWarning;
import io.confluent.ksql.rest.entity.SimpleConnectorInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public class ConnectorList
extends KsqlEntity {
    private final ImmutableList<SimpleConnectorInfo> connectors;

    @JsonCreator
    public ConnectorList(@JsonProperty(value="statementText") String statementText, @JsonProperty(value="warnings") List<KsqlWarning> warnings, @JsonProperty(value="connectors") List<SimpleConnectorInfo> connectors) {
        super(statementText, warnings);
        this.connectors = ImmutableList.copyOf((Collection)Objects.requireNonNull(connectors, "connectors"));
    }

    public ImmutableList<SimpleConnectorInfo> getConnectors() {
        return this.connectors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorList that = (ConnectorList)o;
        return Objects.equals(this.connectors, that.connectors);
    }

    public int hashCode() {
        return Objects.hash(this.connectors);
    }
}

