/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.rest.entity.SchemaInfo;
import java.util.Objects;
import java.util.Optional;

@Immutable
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public class FieldInfo {
    private final String name;
    private final SchemaInfo schema;
    private final Optional<FieldType> type;

    @JsonCreator
    public FieldInfo(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="schema", required=true) SchemaInfo schema, @JsonProperty(value="fieldType") Optional<FieldType> type) {
        this.name = Objects.requireNonNull(name, "name");
        this.schema = Objects.requireNonNull(schema, "schema");
        this.type = Objects.requireNonNull(type, "type");
    }

    public String getName() {
        return this.name;
    }

    public SchemaInfo getSchema() {
        return this.schema;
    }

    public Optional<FieldType> getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        return other instanceof FieldInfo && Objects.equals(this.name, ((FieldInfo)other).name) && Objects.equals(this.schema, ((FieldInfo)other).schema) && Objects.equals(this.type, ((FieldInfo)other).type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.schema, this.type);
    }

    public String toString() {
        return "FieldInfo{name='" + this.name + '\'' + ", schema=" + this.schema + ", type=" + this.type + '}';
    }

    public static enum FieldType {
        SYSTEM,
        KEY;

    }
}

