/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.rest.entity.QueryStateStoreId;
import io.confluent.ksql.rest.entity.StateStoreLags;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
@JsonIgnoreProperties(ignoreUnknown=true)
public class HostStoreLags {
    private final ImmutableMap<QueryStateStoreId, StateStoreLags> stateStoreLags;
    private final long updateTimeMs;

    @JsonCreator
    public HostStoreLags(@JsonProperty(value="stateStoreLags") Map<QueryStateStoreId, StateStoreLags> stateStoreLags, @JsonProperty(value="updateTimeMs") long updateTimeMs) {
        this.stateStoreLags = ImmutableMap.copyOf(Objects.requireNonNull(stateStoreLags, "stateStoreLags"));
        this.updateTimeMs = updateTimeMs;
    }

    public Optional<StateStoreLags> getStateStoreLags(QueryStateStoreId queryStateStoreId) {
        return Optional.ofNullable(this.stateStoreLags.get((Object)queryStateStoreId));
    }

    public Map<QueryStateStoreId, StateStoreLags> getStateStoreLags() {
        return this.stateStoreLags;
    }

    public long getUpdateTimeMs() {
        return this.updateTimeMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostStoreLags that = (HostStoreLags)o;
        return Objects.equals(this.stateStoreLags, that.stateStoreLags) && this.updateTimeMs == that.updateTimeMs;
    }

    public int hashCode() {
        return Objects.hash(this.stateStoreLags, this.updateTimeMs);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stateStoreLags", this.stateStoreLags).add("updateTimeMs", this.updateTimeMs).toString();
    }
}

