/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.entity.QueryStatusCount;
import io.confluent.ksql.util.KsqlConstants;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RunningQuery {
    private final String queryString;
    private final Set<String> sinks;
    private final Set<String> sinkKafkaTopics;
    private final QueryId id;
    private final QueryStatusCount statusCount;
    private final KsqlConstants.KsqlQueryType queryType;

    @JsonCreator
    public RunningQuery(@JsonProperty(value="queryString") String queryString, @JsonProperty(value="sinks") Set<String> sinks, @JsonProperty(value="sinkKafkaTopics") Set<String> sinkKafkaTopics, @JsonProperty(value="id") QueryId id, @JsonProperty(value="statusCount") QueryStatusCount statusCount, @JsonProperty(value="queryType") KsqlConstants.KsqlQueryType queryType) {
        this.queryString = Objects.requireNonNull(queryString, "queryString");
        this.sinkKafkaTopics = Objects.requireNonNull(sinkKafkaTopics, "sinkKafkaTopics");
        this.sinks = Objects.requireNonNull(sinks, "sinks");
        this.id = Objects.requireNonNull(id, "id");
        this.statusCount = Objects.requireNonNull(statusCount, "statusCount");
        this.queryType = Objects.requireNonNull(queryType, "queryType");
    }

    public String getQueryString() {
        return this.queryString;
    }

    @JsonIgnore
    public String getQuerySingleLine() {
        return this.queryString.replaceAll(System.lineSeparator(), " ");
    }

    public Set<String> getSinks() {
        return this.sinks;
    }

    public Set<String> getSinkKafkaTopics() {
        return this.sinkKafkaTopics;
    }

    public QueryId getId() {
        return this.id;
    }

    @JsonProperty(value="state")
    public Optional<String> getState() {
        return Optional.of(this.statusCount.getAggregateStatus().toString());
    }

    public QueryStatusCount getStatusCount() {
        return this.statusCount;
    }

    public KsqlConstants.KsqlQueryType getQueryType() {
        return this.queryType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RunningQuery)) {
            return false;
        }
        RunningQuery that = (RunningQuery)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.queryString, that.queryString) && Objects.equals(this.sinks, that.sinks) && Objects.equals(this.sinkKafkaTopics, that.sinkKafkaTopics) && Objects.equals(this.statusCount, that.statusCount);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.queryString, this.sinks, this.sinkKafkaTopics, this.statusCount);
    }
}

