/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.rest.entity.FieldInfo;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Immutable
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaInfo {
    private final SqlBaseType type;
    private final ImmutableList<FieldInfo> fields;
    private final SchemaInfo memberSchema;
    @EffectivelyImmutable
    private static final ImmutableMap<SqlBaseType, Function<SchemaInfo, String>> TO_TYPE_STRING = ImmutableMap.builder().put((Object)SqlBaseType.STRING, si -> "VARCHAR(STRING)").put((Object)SqlBaseType.ARRAY, si -> SqlBaseType.ARRAY + "<" + si.memberSchema.toTypeString() + ">").put((Object)SqlBaseType.MAP, si -> SqlBaseType.MAP + "<" + SqlBaseType.STRING + ", " + si.memberSchema.toTypeString() + ">").put((Object)SqlBaseType.STRUCT, si -> si.fields.stream().map(f -> f.getName() + " " + f.getSchema().toTypeString()).collect(Collectors.joining(", ", SqlBaseType.STRUCT + "<", ">"))).build();

    @JsonCreator
    public SchemaInfo(@JsonProperty(value="type") SqlBaseType type, @JsonProperty(value="fields") List<? extends FieldInfo> fields, @JsonProperty(value="memberSchema") SchemaInfo memberSchema) {
        Objects.requireNonNull(type);
        this.type = type;
        this.fields = fields == null ? null : ImmutableList.copyOf(fields);
        this.memberSchema = memberSchema;
    }

    public SqlBaseType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public String getTypeName() {
        return this.type.name();
    }

    public Optional<List<FieldInfo>> getFields() {
        return Optional.ofNullable(this.fields);
    }

    public Optional<SchemaInfo> getMemberSchema() {
        return Optional.ofNullable(this.memberSchema);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaInfo that = (SchemaInfo)o;
        return this.type == that.type && Objects.equals(this.fields, that.fields) && Objects.equals(this.memberSchema, that.memberSchema);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.fields, this.memberSchema);
    }

    public String toTypeString() {
        return (String)((Function)TO_TYPE_STRING.getOrDefault((Object)this.type, si -> si.type.name())).apply(this);
    }
}

