/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.rest.entity.FunctionType;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SimpleFunctionInfo
implements Comparable<SimpleFunctionInfo> {
    private final String name;
    private final FunctionType type;

    @JsonCreator
    public SimpleFunctionInfo(@JsonProperty(value="name") String name, @JsonProperty(value="type") FunctionType type) {
        this.name = Objects.requireNonNull(name, "name can't be null");
        this.type = Objects.requireNonNull(type, "type can't be null");
    }

    public String getName() {
        return this.name;
    }

    public FunctionType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFunctionInfo that = (SimpleFunctionInfo)o;
        return Objects.equals(this.name, that.name) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    public String toString() {
        return "SimpleFunctionInfo{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    @Override
    public int compareTo(SimpleFunctionInfo other) {
        return this.name.compareTo(other.name);
    }
}

