/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TableRowsEntity
extends KsqlEntity {
    private final LogicalSchema schema;
    private final QueryId queryId;
    private final ImmutableList<List<?>> rows;

    public TableRowsEntity(@JsonProperty(value="statementText") String statementText, @JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="schema") LogicalSchema schema, @JsonProperty(value="rows") List<List<?>> rows) {
        super(statementText);
        this.schema = Objects.requireNonNull(schema, "schema");
        this.queryId = Objects.requireNonNull(queryId, "queryId");
        this.rows = TableRowsEntity.deepCopy(Objects.requireNonNull(rows, "rows"));
        rows.forEach(this::validate);
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public List<List<?>> getRows() {
        return this.rows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableRowsEntity)) {
            return false;
        }
        TableRowsEntity that = (TableRowsEntity)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.rows, that.rows);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.rows);
    }

    private void validate(List<?> row) {
        int actualSize;
        int expectedSize = this.schema.key().size() + this.schema.value().size();
        if (expectedSize != (actualSize = row.size())) {
            throw new IllegalArgumentException("column count mismatch. expected: " + expectedSize + ", got: " + actualSize);
        }
    }

    private static ImmutableList<List<?>> deepCopy(List<List<?>> rows) {
        ImmutableList.Builder builder = ImmutableList.builder();
        rows.stream().map(ArrayList::new).map(Collections::unmodifiableList).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }
}

