/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ArgumentInfo {
    private final String name;
    private final String type;
    private final String description;
    private final boolean isVariadic;

    @JsonCreator
    public ArgumentInfo(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description, @JsonProperty(value="isVariadic") Boolean isVariadic) {
        this.name = name == null ? "" : name;
        this.type = Objects.requireNonNull(type, "type");
        this.description = description == null ? "" : description;
        this.isVariadic = isVariadic == null ? false : isVariadic;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsVariadic() {
        return this.isVariadic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArgumentInfo that = (ArgumentInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.description, that.description) && this.isVariadic == that.isVariadic;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.description, this.isVariadic);
    }

    public String toString() {
        return "ArgumentInfo{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", description='" + this.description + '\'' + ", isVariadic=" + this.isVariadic + '}';
    }
}

