/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlHostInfo;
import java.util.Objects;

@Immutable
@JsonIgnoreProperties(ignoreUnknown=true)
public class KsqlHostInfoEntity {
    private final String host;
    private final int port;

    public KsqlHostInfoEntity(String host, int port) {
        this.host = Objects.requireNonNull(host, "host");
        this.port = port;
    }

    @JsonCreator
    public KsqlHostInfoEntity(String serializedPair) {
        String[] parts = serializedPair.split(":");
        if (parts.length != 2) {
            throw new KsqlException("Invalid host info. Expected format: <hostname>:<port>, but was " + serializedPair);
        }
        this.host = Objects.requireNonNull(parts[0], "host");
        try {
            this.port = Integer.parseInt(parts[1]);
        }
        catch (Exception e) {
            throw new KsqlException("Invalid port. Expected format: <hostname>:<port>, but was " + serializedPair, (Throwable)e);
        }
    }

    public KsqlHostInfoEntity(KsqlHostInfo ksqlHostInfo) {
        this.host = ksqlHostInfo.host();
        this.port = ksqlHostInfo.port();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public KsqlHostInfo toKsqlHost() {
        return new KsqlHostInfo(this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlHostInfoEntity that = (KsqlHostInfoEntity)o;
        return Objects.equals(this.host, that.host) && this.port == that.port;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    @JsonValue
    public String toString() {
        return this.host + ":" + this.port;
    }
}

