/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="STREAM", value=Stream.class), @JsonSubTypes.Type(name="TABLE", value=Table.class)})
public class SourceInfo {
    private final String name;
    private final String topic;
    private final String format;

    public SourceInfo(String name, String topic, String format) {
        this.name = name;
        this.topic = topic;
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceInfo that = (SourceInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.topic, that.topic) && Objects.equals(this.format, that.format);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.topic, this.format);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Table
    extends SourceInfo {
        private final boolean isWindowed;

        @JsonCreator
        public Table(@JsonProperty(value="name") String name, @JsonProperty(value="topic") String topic, @JsonProperty(value="format") String format, @JsonProperty(value="isWindowed") Boolean isWindowed) {
            super(name, topic, format);
            this.isWindowed = isWindowed;
        }

        public boolean getIsWindowed() {
            return this.isWindowed;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Table table = (Table)o;
            return this.isWindowed == table.isWindowed;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.isWindowed);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Stream
    extends SourceInfo {
        @JsonCreator
        public Stream(@JsonProperty(value="name") String name, @JsonProperty(value="topic") String topic, @JsonProperty(value="format") String format) {
            super(name, topic, format);
        }
    }
}

