/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;

@Immutable
@JsonIgnoreProperties(ignoreUnknown=true)
public class TopicPartitionEntity {
    private final String topic;
    private final int partition;

    @JsonCreator
    public TopicPartitionEntity(@JsonProperty(value="topic") String topic, @JsonProperty(value="partition") int partition) {
        this.topic = topic;
        this.partition = partition;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartitionEntity that = (TopicPartitionEntity)o;
        return this.topic.equals(that.topic) && this.partition == that.partition;
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partition);
    }

    public String toString() {
        return "TopicPartition{topic=" + this.topic + ", partition=" + this.partition + '}';
    }
}

