/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.entity.ArgumentInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FunctionInfo {
    private final List<ArgumentInfo> arguments;
    private final String returnType;
    private final String description;

    @JsonCreator
    public FunctionInfo(@JsonProperty(value="arguments") List<ArgumentInfo> arguments, @JsonProperty(value="returnType") String returnType, @JsonProperty(value="description") String description) {
        this.arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments"));
        this.returnType = Objects.requireNonNull(returnType, "returnType can't be null");
        this.description = Objects.requireNonNull(description, "description can't be null");
    }

    @Deprecated
    public List<String> getArgumentTypes() {
        return this.arguments.stream().map(ArgumentInfo::getType).collect(Collectors.toList());
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="arguments is ImmutableList")
    public List<ArgumentInfo> getArguments() {
        return this.arguments;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionInfo that = (FunctionInfo)o;
        return Objects.equals(this.arguments, that.arguments) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.arguments, this.returnType, this.description);
    }

    public String toString() {
        return "FunctionInfo{arguments=" + this.arguments + ", returnType='" + this.returnType + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

