/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.logging.processing;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.logging.processing.DeserializationError;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.serialization.Deserializer;

public final class LoggingDeserializer<T>
implements Deserializer<T> {
    private final Deserializer<T> delegate;
    private final ProcessingLogger processingLogger;
    private boolean isKey;

    public LoggingDeserializer(Deserializer<T> delegate, ProcessingLogger processingLogger) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.processingLogger = Objects.requireNonNull(processingLogger, "processingLogger");
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.delegate.configure(configs, isKey);
    }

    public T deserialize(String topic, byte[] bytes) {
        return this.tryDeserialize(topic, bytes).get();
    }

    public DelayedResult<T> tryDeserialize(String topic, byte[] bytes) {
        try {
            return new DelayedResult<Object>(this.delegate.deserialize(topic, bytes));
        }
        catch (RuntimeException e) {
            return new DelayedResult(e, new DeserializationError(e, Optional.ofNullable(bytes), topic, this.isKey), this.processingLogger);
        }
    }

    public void close() {
        this.delegate.close();
    }

    public static class DelayedResult<T> {
        private final T result;
        private final RuntimeException error;
        private final ProcessingLogger processingLogger;
        private final DeserializationError deserializationError;

        public DelayedResult(RuntimeException error, DeserializationError deserializationError, ProcessingLogger processingLogger) {
            this.result = null;
            this.error = error;
            this.deserializationError = Objects.requireNonNull(deserializationError, "deserializationError");
            this.processingLogger = Objects.requireNonNull(processingLogger, "processingLogger");
        }

        public DelayedResult(T result) {
            this.result = result;
            this.error = null;
            this.deserializationError = null;
            this.processingLogger = null;
        }

        public boolean isError() {
            return this.error != null;
        }

        @VisibleForTesting
        RuntimeException getError() {
            return this.error;
        }

        public T get() {
            if (this.isError()) {
                this.processingLogger.error((ProcessingLogger.ErrorMessage)this.deserializationError);
                throw this.error;
            }
            return this.result;
        }
    }
}

