/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.serde.FormatProperties;
import io.confluent.ksql.serde.SchemaTranslator;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.kafka.common.serialization.Serde;

@ThreadSafe
public interface Format {
    public String name();

    default public Set<SerdeFeature> supportedFeatures() {
        return ImmutableSet.of();
    }

    default public boolean supportsFeature(SerdeFeature feature) {
        return this.supportedFeatures().contains(feature);
    }

    default public SchemaTranslator getSchemaTranslator(Map<String, String> formatProperties) {
        throw new UnsupportedOperationException(this.name() + " does not implement Schema Registry support");
    }

    default public void validateProperties(Map<String, String> properties) {
        FormatProperties.validateProperties(this.name(), properties, this.getSupportedProperties());
    }

    default public Set<String> getSupportedProperties() {
        return ImmutableSet.of();
    }

    default public Set<String> getInheritableProperties() {
        return this.getSupportedProperties();
    }

    public Serde<List<?>> getSerde(PersistenceSchema var1, Map<String, String> var2, KsqlConfig var3, Supplier<SchemaRegistryClient> var4, boolean var5);
}

