/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.avro.AvroFormat;
import io.confluent.ksql.serde.delimited.DelimitedFormat;
import io.confluent.ksql.serde.json.JsonFormat;
import io.confluent.ksql.serde.json.JsonSchemaFormat;
import io.confluent.ksql.serde.kafka.KafkaFormat;
import io.confluent.ksql.serde.none.NoneFormat;
import io.confluent.ksql.serde.protobuf.ProtobufFormat;
import io.confluent.ksql.util.KsqlException;

public final class FormatFactory {
    public static final Format AVRO = new AvroFormat();
    public static final Format JSON = new JsonFormat();
    public static final Format JSON_SR = new JsonSchemaFormat();
    public static final Format PROTOBUF = new ProtobufFormat();
    public static final Format KAFKA = new KafkaFormat();
    public static final Format DELIMITED = new DelimitedFormat();
    public static final Format NONE = new NoneFormat();

    private FormatFactory() {
    }

    public static Format of(FormatInfo formatInfo) {
        Format format = FormatFactory.fromName(formatInfo.getFormat().toUpperCase());
        format.validateProperties(formatInfo.getProperties());
        return format;
    }

    public static Format fromName(String name) {
        switch (name.toUpperCase()) {
            case "AVRO": {
                return AVRO;
            }
            case "JSON": {
                return JSON;
            }
            case "JSON_SR": {
                return JSON_SR;
            }
            case "PROTOBUF": {
                return PROTOBUF;
            }
            case "KAFKA": {
                return KAFKA;
            }
            case "DELIMITED": {
                return DELIMITED;
            }
            case "NONE": {
                return NONE;
            }
        }
        throw new KsqlException("Unknown format: " + name);
    }
}

