/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.GenericSerdeFactory;
import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.serde.ValueSerdeFactory;
import io.confluent.ksql.serde.tracked.TrackedCallback;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public final class GenericRowSerDe
implements ValueSerdeFactory {
    private static final int ADDITIONAL_CAPACITY = 4;
    private final GenericSerdeFactory innerFactory;

    public GenericRowSerDe() {
        this(new GenericSerdeFactory());
    }

    @VisibleForTesting
    GenericRowSerDe(GenericSerdeFactory innerFactory) {
        this.innerFactory = Objects.requireNonNull(innerFactory, "innerFactory");
    }

    public static Serde<GenericRow> from(FormatInfo format, PersistenceSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> schemaRegistryClientFactory, String loggerNamePrefix, ProcessingLogContext processingLogContext) {
        return new GenericRowSerDe().create(format, schema, ksqlConfig, schemaRegistryClientFactory, loggerNamePrefix, processingLogContext, Optional.empty());
    }

    @Override
    public Serde<GenericRow> create(FormatInfo format, PersistenceSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srClientFactory, String loggerNamePrefix, ProcessingLogContext processingLogContext, Optional<TrackedCallback> tracker) {
        Serde<List<?>> formatSerde = this.innerFactory.createFormatSerde("Value", format, schema, ksqlConfig, srClientFactory, false);
        Serde<GenericRow> genericRowSerde = GenericRowSerDe.toGenericRowSerde(formatSerde, schema);
        Serde<GenericRow> loggingSerde = this.innerFactory.wrapInLoggingSerde(genericRowSerde, loggerNamePrefix, processingLogContext);
        Serde<GenericRow> serde = tracker.map(callback -> this.innerFactory.wrapInTrackingSerde(loggingSerde, (TrackedCallback)callback)).orElse(loggingSerde);
        serde.configure(Collections.emptyMap(), false);
        return serde;
    }

    private static Serde<GenericRow> toGenericRowSerde(Serde<List<?>> innerSerde, PersistenceSchema schema) {
        GenericRowSerializer serializer = new GenericRowSerializer(innerSerde.serializer(), schema.columns().size());
        GenericRowDeserializer deserializer = new GenericRowDeserializer(innerSerde.deserializer(), schema.columns().size());
        return Serdes.serdeFrom((Serializer)serializer, (Deserializer)deserializer);
    }

    @VisibleForTesting
    static class GenericRowDeserializer
    implements Deserializer<GenericRow> {
        private final Deserializer<List<?>> inner;
        private final int numColumns;

        GenericRowDeserializer(Deserializer<List<?>> inner, int numColumns) {
            this.inner = Objects.requireNonNull(inner, "inner");
            this.numColumns = numColumns;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.inner.configure(configs, isKey);
        }

        public void close() {
            this.inner.close();
        }

        public GenericRow deserialize(String topic, byte[] data) {
            List values = (List)this.inner.deserialize(topic, data);
            if (values == null) {
                return null;
            }
            SerdeUtils.throwOnColumnCountMismatch(this.numColumns, values.size(), false, topic);
            GenericRow row = new GenericRow(values.size() + 4);
            row.appendAll((Collection)values);
            return row;
        }
    }

    @VisibleForTesting
    static class GenericRowSerializer
    implements Serializer<GenericRow> {
        private final Serializer<List<?>> inner;
        private final int numColumns;

        GenericRowSerializer(Serializer<List<?>> inner, int numColumns) {
            this.inner = Objects.requireNonNull(inner, "inner");
            this.numColumns = numColumns;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
            this.inner.configure(configs, isKey);
        }

        public byte[] serialize(String topic, GenericRow data) {
            if (data == null) {
                return this.inner.serialize(topic, null);
            }
            SerdeUtils.throwOnColumnCountMismatch(this.numColumns, data.size(), true, topic);
            return this.inner.serialize(topic, (Object)data.values());
        }

        public void close() {
            this.inner.close();
        }
    }
}

