/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.SchemaNotSupportedException;
import io.confluent.ksql.logging.processing.LoggingDeserializer;
import io.confluent.ksql.logging.processing.LoggingSerializer;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.ProcessingLoggerUtil;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.tracked.TrackedCallback;
import io.confluent.ksql.serde.tracked.TrackedSerde;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;

final class GenericSerdeFactory {
    private static final String SERIALIZER_LOGGER_NAME = "serializer";
    private static final String DESERIALIZER_LOGGER_NAME = "deserializer";
    private final Function<FormatInfo, Format> formatFactory;

    GenericSerdeFactory() {
        this(FormatFactory::of);
    }

    @VisibleForTesting
    GenericSerdeFactory(Function<FormatInfo, Format> formatFactory) {
        this.formatFactory = Objects.requireNonNull(formatFactory, "formatFactory");
    }

    Serde<List<?>> createFormatSerde(String target, FormatInfo formatInfo, PersistenceSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> schemaRegistryClientFactory, boolean isKey) {
        Format format = this.formatFactory.apply(formatInfo);
        try {
            return format.getSerde(schema, formatInfo.getProperties(), ksqlConfig, schemaRegistryClientFactory, isKey);
        }
        catch (Exception e) {
            throw new SchemaNotSupportedException(target + " format does not support schema." + System.lineSeparator() + "format: " + format.name() + System.lineSeparator() + "schema: " + schema + System.lineSeparator() + "reason: " + e.getMessage(), (Throwable)e);
        }
    }

    <T> Serde<T> wrapInLoggingSerde(Serde<T> formatSerde, String loggerNamePrefix, ProcessingLogContext processingLogContext) {
        ProcessingLogger serializerProcessingLogger = processingLogContext.getLoggerFactory().getLogger(ProcessingLoggerUtil.join((String[])new String[]{loggerNamePrefix, SERIALIZER_LOGGER_NAME}));
        ProcessingLogger deserializerProcessingLogger = processingLogContext.getLoggerFactory().getLogger(ProcessingLoggerUtil.join((String[])new String[]{loggerNamePrefix, DESERIALIZER_LOGGER_NAME}));
        return Serdes.serdeFrom(new LoggingSerializer(formatSerde.serializer(), serializerProcessingLogger), new LoggingDeserializer(formatSerde.deserializer(), deserializerProcessingLogger));
    }

    <T> Serde<T> wrapInTrackingSerde(Serde<T> serde, TrackedCallback callback) {
        return TrackedSerde.from(serde, callback);
    }
}

