/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;

public final class KeyFormatUtils {
    private static final List<Format> SUPPORTED_KEY_FORMATS = ImmutableList.of((Object)FormatFactory.NONE, (Object)FormatFactory.KAFKA, (Object)FormatFactory.DELIMITED, (Object)FormatFactory.JSON);
    private static final List<Format> KEY_FORMATS_UNDER_DEVELOPMENT = ImmutableList.of((Object)FormatFactory.AVRO, (Object)FormatFactory.JSON_SR);

    public static boolean isSupportedKeyFormat(KsqlConfig config, Format format) {
        if (SUPPORTED_KEY_FORMATS.contains(format)) {
            return true;
        }
        return config.getBoolean("ksql.key.format.enabled") != false && KEY_FORMATS_UNDER_DEVELOPMENT.contains(format);
    }

    private KeyFormatUtils() {
    }
}

