/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.collect.Sets;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.unwrapped.UnwrappedDeserializer;
import io.confluent.ksql.serde.unwrapped.UnwrappedSerializer;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public final class SerdeUtils {
    private SerdeUtils() {
    }

    public static void throwOnUnsupportedFeatures(SerdeFeatures requestedFeatures, Set<SerdeFeature> supportedFeatures) {
        Sets.SetView unsupported = Sets.difference((Set)requestedFeatures.all(), supportedFeatures);
        if (!unsupported.isEmpty()) {
            throw new IllegalArgumentException("Unsupported features: " + unsupported);
        }
    }

    public static ConnectSchema applySinglesUnwrapping(Schema schema, SerdeFeatures features) {
        boolean singleField;
        if (!features.enabled(SerdeFeature.UNWRAP_SINGLES)) {
            return (ConnectSchema)schema;
        }
        boolean bl = singleField = schema.fields().size() == 1;
        if (!singleField) {
            throw new IllegalArgumentException("Unwrapping only valid for single columns");
        }
        return (ConnectSchema)((Field)schema.fields().get(0)).schema();
    }

    public static Schema wrapSingle(Schema fieldSchema, boolean isKey) {
        String fieldName = isKey ? "ROWKEY" : "ROWVAL";
        return SchemaBuilder.struct().field(fieldName, fieldSchema).build();
    }

    public static <T> Serializer<List<?>> unwrappedSerializer(Serializer<T> inner, Class<T> type) {
        return new UnwrappedSerializer<T>(inner, type);
    }

    public static Deserializer<List<?>> unwrappedDeserializer(Deserializer<?> inner) {
        return new UnwrappedDeserializer(inner);
    }

    public static <T> T safeCast(Object value, Class<T> javaType) {
        if (value != null && !javaType.isAssignableFrom(value.getClass())) {
            throw new SerializationException("value does not match expected type. expected: " + javaType.getSimpleName() + ", but got: " + value.getClass().getSimpleName());
        }
        return (T)value;
    }

    public static void throwOnSchemaJavaTypeMismatch(Schema schema, Class<?> javaType) {
        Class schemaType = SchemaConverters.connectToJavaTypeConverter().toJavaType(schema);
        if (!schemaType.equals(javaType)) {
            throw new IllegalArgumentException("schema does not match expected java type. Expected: " + javaType + ", but got " + schemaType);
        }
    }

    public static void throwOnColumnCountMismatch(int expectedCount, int actualCount, boolean serialization, String topic) {
        if (expectedCount == actualCount) {
            return;
        }
        throw new SerializationException("Column count mismatch on " + (serialization ? "serialization" : "deserialization") + ". topic: " + topic + ", expected: " + expectedCount + ", got: " + actualCount);
    }

    public static <T> T castToTargetType(Object val, Class<T> type) {
        if (val != null && !type.isAssignableFrom(val.getClass())) {
            throw new SerializationException("Data deserialized to wrong type. Expected type: " + type + ", but got: " + val);
        }
        return (T)val;
    }
}

