/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.serde.FormatInfo;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class ValueFormat {
    private final FormatInfo format;
    private final SerdeFeatures features;

    public static ValueFormat of(FormatInfo format, SerdeFeatures features) {
        return new ValueFormat(format, features);
    }

    @JsonCreator
    private static ValueFormat create(@JsonProperty(value="format", required=true) String format, @JsonProperty(value="properties") Optional<Map<String, String>> properties, @JsonProperty(value="features") Optional<SerdeFeatures> features) {
        return new ValueFormat(FormatInfo.of((String)format, (Map)properties.orElseGet(ImmutableMap::of)), features.orElseGet(() -> SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0])));
    }

    private ValueFormat(FormatInfo format, SerdeFeatures features) {
        this.format = Objects.requireNonNull(format, "format");
        this.features = Objects.requireNonNull(features, "features");
    }

    public String getFormat() {
        return this.format.getFormat();
    }

    public Map<String, String> getProperties() {
        return this.format.getProperties();
    }

    @JsonIgnore
    public FormatInfo getFormatInfo() {
        return this.format;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=SerdeFeatures.NOT_EMPTY.class)
    public SerdeFeatures getFeatures() {
        return this.features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueFormat that = (ValueFormat)o;
        return Objects.equals(this.format, that.format) && Objects.equals(this.features, that.features);
    }

    public int hashCode() {
        return Objects.hash(this.format, this.features);
    }

    public String toString() {
        return "ValueFormat{format=" + this.format + ", features=" + this.features + '}';
    }
}

