/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.avro;

import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.avro.AvroProperties;
import io.confluent.ksql.serde.avro.AvroSchemaTranslator;
import io.confluent.ksql.serde.avro.KsqlAvroSerdeFactory;
import io.confluent.ksql.serde.connect.ConnectFormat;
import io.confluent.ksql.serde.connect.ConnectSchemaTranslator;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;

public final class AvroFormat
extends ConnectFormat {
    private static final ImmutableSet<SerdeFeature> SUPPORTED_FEATURES = ImmutableSet.of((Object)SerdeFeature.SCHEMA_INFERENCE, (Object)SerdeFeature.WRAP_SINGLES, (Object)SerdeFeature.UNWRAP_SINGLES);
    public static final String FULL_SCHEMA_NAME = "fullSchemaName";
    public static final String NAME = "AVRO";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Set<SerdeFeature> supportedFeatures() {
        return SUPPORTED_FEATURES;
    }

    @Override
    public Set<String> getSupportedProperties() {
        return AvroProperties.SUPPORTED_PROPERTIES;
    }

    @Override
    public Set<String> getInheritableProperties() {
        return ImmutableSet.of();
    }

    @Override
    protected ConnectSchemaTranslator getConnectSchemaTranslator(Map<String, String> formatProps) {
        return new AvroSchemaTranslator(new AvroProperties(formatProps));
    }

    @Override
    protected <T> Serde<T> getConnectSerde(ConnectSchema connectSchema, Map<String, String> formatProps, KsqlConfig config, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        this.getConnectSchemaTranslator(formatProps).fromConnectSchema((Schema)connectSchema);
        String schemaFullName = new AvroProperties(formatProps).getFullSchemaName();
        return new KsqlAvroSerdeFactory(schemaFullName).createSerde(connectSchema, config, srFactory, targetType, isKey);
    }
}

