/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.avro;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.serde.FormatProperties;
import java.util.Map;

@Immutable
class AvroProperties {
    static final String AVRO_SCHEMA_NAMESPACE = "io.confluent.ksql.avro_schemas";
    static final String AVRO_SCHEMA_NAME = "KsqlDataSourceSchema";
    static final String DEFAULT_AVRO_SCHEMA_FULL_NAME = "io.confluent.ksql.avro_schemas.KsqlDataSourceSchema";
    static final String FULL_SCHEMA_NAME = "fullSchemaName";
    static final ImmutableSet<String> SUPPORTED_PROPERTIES = ImmutableSet.of((Object)"fullSchemaName");
    private final ImmutableMap<String, String> properties;

    AvroProperties(Map<String, String> formatProps) {
        this.properties = ImmutableMap.copyOf(formatProps);
        FormatProperties.validateProperties("AVRO", formatProps, SUPPORTED_PROPERTIES);
    }

    String getFullSchemaName() {
        return (String)this.properties.getOrDefault((Object)FULL_SCHEMA_NAME, (Object)DEFAULT_AVRO_SCHEMA_FULL_NAME);
    }
}

