/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.avro;

import com.google.common.collect.ImmutableMap;
import io.confluent.connect.avro.AvroData;
import io.confluent.connect.avro.AvroDataConfig;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.ksql.serde.avro.AvroProperties;
import io.confluent.ksql.serde.avro.AvroSchemas;
import io.confluent.ksql.serde.connect.ConnectSchemaTranslator;
import io.confluent.ksql.util.KsqlException;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.SchemaParseException;
import org.apache.kafka.connect.data.Schema;

class AvroSchemaTranslator
implements ConnectSchemaTranslator {
    private final AvroData avroData = new AvroData(new AvroDataConfig((Map)ImmutableMap.of()));
    private final AvroProperties formatProps;

    AvroSchemaTranslator(AvroProperties formatProps) {
        this.formatProps = Objects.requireNonNull(formatProps, "formatProps");
    }

    @Override
    public String name() {
        return "AVRO";
    }

    @Override
    public Schema toConnectSchema(ParsedSchema schema) {
        return this.avroData.toConnectSchema(((AvroSchema)schema).rawSchema());
    }

    @Override
    public ParsedSchema fromConnectSchema(Schema schema) {
        Schema avroCompatibleSchema = AvroSchemas.getAvroCompatibleConnectSchema(schema, this.formatProps.getFullSchemaName());
        try {
            return new AvroSchema(this.avroData.fromConnectSchema(avroCompatibleSchema));
        }
        catch (SchemaParseException e) {
            throw new KsqlException("Schema is not compatible with Avro: " + e.getMessage(), (Throwable)e);
        }
    }
}

