/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.avro;

import com.google.common.base.Preconditions;
import io.confluent.ksql.schema.connect.SchemaWalker;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlException;
import org.apache.kafka.connect.data.Schema;

final class AvroUtil {
    private AvroUtil() {
    }

    static Schema throwOnInvalidSchema(Schema schema) {
        class SchemaValidator
        implements SchemaWalker.Visitor<Void, Void> {
            SchemaValidator() {
            }

            public Void visitMap(Schema schema, Void key, Void value) {
                if (schema.keySchema().type() != Schema.Type.STRING) {
                    throw new KsqlException("Avro only supports MAPs with STRING keys");
                }
                return null;
            }

            public Void visitBytes(Schema schema) {
                Preconditions.checkArgument((boolean)DecimalUtil.isDecimal((Schema)schema), (Object)"Avro only supports DECIMAL for BYTES type.");
                return null;
            }

            public Void visitSchema(Schema schema) {
                return null;
            }
        }
        SchemaWalker.visit((Schema)schema, (SchemaWalker.Visitor)new SchemaValidator());
        return schema;
    }
}

