/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.avro;

import com.google.errorprone.annotations.Immutable;
import io.confluent.connect.avro.AvroConverter;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.serde.avro.AvroDataTranslator;
import io.confluent.ksql.serde.avro.AvroUtil;
import io.confluent.ksql.serde.connect.KsqlConnectDeserializer;
import io.confluent.ksql.serde.connect.KsqlConnectSerializer;
import io.confluent.ksql.serde.tls.ThreadLocalDeserializer;
import io.confluent.ksql.serde.tls.ThreadLocalSerializer;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.storage.Converter;

@Immutable
class KsqlAvroSerdeFactory {
    private final String fullSchemaName;

    KsqlAvroSerdeFactory(String fullSchemaName) {
        this.fullSchemaName = Objects.requireNonNull(fullSchemaName, "fullSchemaName").trim();
        if (this.fullSchemaName.isEmpty()) {
            throw new IllegalArgumentException("the schema name cannot be empty");
        }
    }

    <T> Serde<T> createSerde(ConnectSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        AvroUtil.throwOnInvalidSchema((Schema)schema);
        Supplier<Serializer<T>> serializerSupplier = this.createConnectSerializer(schema, ksqlConfig, srFactory, targetType, isKey);
        Supplier<Deserializer<T>> deserializerSupplier = this.createConnectDeserializer(schema, ksqlConfig, srFactory, targetType, isKey);
        serializerSupplier.get();
        deserializerSupplier.get();
        return Serdes.serdeFrom(new ThreadLocalSerializer<T>(serializerSupplier), new ThreadLocalDeserializer<T>(deserializerSupplier));
    }

    private <T> Supplier<Serializer<T>> createConnectSerializer(ConnectSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        return () -> {
            AvroDataTranslator translator = this.createAvroTranslator((Schema)schema);
            AvroConverter avroConverter = KsqlAvroSerdeFactory.getAvroConverter((SchemaRegistryClient)srFactory.get(), ksqlConfig, isKey);
            return new KsqlConnectSerializer(translator.getAvroCompatibleSchema(), translator, (Converter)avroConverter, targetType);
        };
    }

    private <T> Supplier<Deserializer<T>> createConnectDeserializer(ConnectSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        return () -> {
            AvroDataTranslator translator = this.createAvroTranslator((Schema)schema);
            AvroConverter avroConverter = KsqlAvroSerdeFactory.getAvroConverter((SchemaRegistryClient)srFactory.get(), ksqlConfig, isKey);
            return new KsqlConnectDeserializer((Converter)avroConverter, translator, targetType);
        };
    }

    private AvroDataTranslator createAvroTranslator(Schema schema) {
        return new AvroDataTranslator(schema, this.fullSchemaName);
    }

    private static AvroConverter getAvroConverter(SchemaRegistryClient schemaRegistryClient, KsqlConfig ksqlConfig, boolean isKey) {
        AvroConverter avroConverter = new AvroConverter(schemaRegistryClient);
        Map avroConfig = ksqlConfig.originalsWithPrefix("ksql.schema.registry.");
        avroConfig.put("schema.registry.url", ksqlConfig.getString("ksql.schema.registry.url"));
        avroConfig.put("connect.meta.data", false);
        avroConverter.configure(avroConfig, isKey);
        return avroConverter;
    }
}

