/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.connect;

import com.google.errorprone.annotations.Immutable;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.serde.SchemaTranslator;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.serde.connect.ConnectFormat;
import io.confluent.ksql.serde.connect.ConnectSchemaTranslator;
import io.confluent.ksql.serde.connect.ConnectSchemas;
import io.confluent.ksql.util.KsqlException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

class ConnectFormatSchemaTranslator
implements SchemaTranslator {
    private final ConnectFormat format;
    private final ConnectSchemaTranslator connectSrTranslator;
    private final Function<Schema, Schema> connectKsqlTranslator;

    ConnectFormatSchemaTranslator(ConnectFormat format, Map<String, String> formatProps, Function<Schema, Schema> connectKsqlTranslator) {
        this.format = Objects.requireNonNull(format, "format");
        this.connectSrTranslator = Objects.requireNonNull(format.getConnectSchemaTranslator(formatProps));
        this.connectKsqlTranslator = Objects.requireNonNull(connectKsqlTranslator, "toKsqlTransformer");
    }

    @Override
    public String name() {
        return this.connectSrTranslator.name();
    }

    @Override
    public List<SimpleColumn> toColumns(ParsedSchema schema, SerdeFeatures serdeFeatures, boolean isKey) {
        SerdeUtils.throwOnUnsupportedFeatures(serdeFeatures, this.format.supportedFeatures());
        Schema connectSchema = this.connectSrTranslator.toConnectSchema(schema);
        if (serdeFeatures.enabled(SerdeFeature.UNWRAP_SINGLES)) {
            connectSchema = SerdeUtils.wrapSingle(connectSchema, isKey);
        }
        if (connectSchema.type() != Schema.Type.STRUCT) {
            if (isKey) {
                throw new IllegalStateException("Key schemas are always unwrapped.");
            }
            throw new KsqlException("Schema returned from schema registry is anonymous type. To use this schema with ksqlDB, set 'WRAP_SINGLE_VALUE=false' in the WITH clause properties.");
        }
        Schema rowSchema = this.connectKsqlTranslator.apply(connectSchema);
        return rowSchema.fields().stream().map(ConnectFormatSchemaTranslator::toColumn).collect(Collectors.toList());
    }

    @Override
    public ParsedSchema toParsedSchema(PersistenceSchema schema) {
        SerdeUtils.throwOnUnsupportedFeatures(schema.features(), this.format.supportedFeatures());
        ConnectSchema outerSchema = ConnectSchemas.columnsToConnectSchema(schema.columns());
        ConnectSchema innerSchema = SerdeUtils.applySinglesUnwrapping((Schema)outerSchema, schema.features());
        return this.connectSrTranslator.fromConnectSchema((Schema)innerSchema);
    }

    private static SimpleColumn toColumn(Field field) {
        ColumnName name = ColumnName.of((String)field.name());
        SqlType type = SchemaConverters.connectToSqlConverter().toSqlType(field.schema());
        return new ConnectColumn(name, type);
    }

    @Immutable
    private static final class ConnectColumn
    implements SimpleColumn {
        private final ColumnName name;
        private final SqlType type;

        private ConnectColumn(ColumnName name, SqlType type) {
            this.name = Objects.requireNonNull(name, "name");
            this.type = Objects.requireNonNull(type, "type");
        }

        public ColumnName name() {
            return this.name;
        }

        public SqlType type() {
            return this.type;
        }
    }
}

