/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.connect;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.schema.connect.SqlSchemaFormatter;
import io.confluent.ksql.serde.connect.ConnectSchemaTranslator;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlException;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectSchemaUtil {
    private static final Logger log = LoggerFactory.getLogger(ConnectSchemaTranslator.class);
    private static final SqlSchemaFormatter FORMATTER = new SqlSchemaFormatter(w -> false, new SqlSchemaFormatter.Option[]{SqlSchemaFormatter.Option.AS_COLUMN_LIST});
    private static final Map<Schema.Type, Function<Schema, Schema>> CONNECT_TO_KSQL = ImmutableMap.builder().put((Object)Schema.Type.INT8, s -> Schema.OPTIONAL_INT32_SCHEMA).put((Object)Schema.Type.INT16, s -> Schema.OPTIONAL_INT32_SCHEMA).put((Object)Schema.Type.INT32, s -> Schema.OPTIONAL_INT32_SCHEMA).put((Object)Schema.Type.INT64, s -> Schema.OPTIONAL_INT64_SCHEMA).put((Object)Schema.Type.FLOAT32, s -> Schema.OPTIONAL_FLOAT64_SCHEMA).put((Object)Schema.Type.FLOAT64, s -> Schema.OPTIONAL_FLOAT64_SCHEMA).put((Object)Schema.Type.STRING, s -> Schema.OPTIONAL_STRING_SCHEMA).put((Object)Schema.Type.BOOLEAN, s -> Schema.OPTIONAL_BOOLEAN_SCHEMA).put((Object)Schema.Type.BYTES, ConnectSchemaUtil::toKsqlBytesSchema).put((Object)Schema.Type.ARRAY, ConnectSchemaUtil::toKsqlArraySchema).put((Object)Schema.Type.MAP, ConnectSchemaUtil::toKsqlMapSchema).put((Object)Schema.Type.STRUCT, ConnectSchemaUtil::toKsqlStructSchema).build();

    private ConnectSchemaUtil() {
    }

    public static Schema toKsqlSchema(Schema schema) {
        try {
            Schema rowSchema = ConnectSchemaUtil.toKsqlFieldSchema(schema);
            if (rowSchema.type() != Schema.Type.STRUCT) {
                throw new KsqlException("KSQL stream/table schema must be structured");
            }
            if (rowSchema.fields().isEmpty()) {
                throw new KsqlException("Schema does not include any columns with types that ksqlDB supports." + System.lineSeparator() + "schema: " + FORMATTER.format(schema));
            }
            return rowSchema;
        }
        catch (UnsupportedTypeException e) {
            throw new KsqlException("Unsupported type at root of schema: " + e.getMessage(), (Throwable)e);
        }
    }

    private static Schema toKsqlFieldSchema(Schema schema) {
        Function<Schema, Schema> handler = CONNECT_TO_KSQL.get(schema.type());
        if (handler == null) {
            throw new UnsupportedTypeException(String.format("Unsupported type: %s", schema.type().getName()));
        }
        return handler.apply(schema);
    }

    private static void checkMapKeyType(Schema.Type type) {
        switch (type) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case BOOLEAN: 
            case STRING: {
                return;
            }
        }
        throw new UnsupportedTypeException("Unsupported type for map key: " + type.getName());
    }

    private static Schema toKsqlBytesSchema(Schema schema) {
        if (DecimalUtil.isDecimal((Schema)schema)) {
            return schema;
        }
        throw new UnsupportedTypeException("BYTES type must be DECIMAL schema.");
    }

    private static Schema toKsqlMapSchema(Schema schema) {
        Schema keySchema = ConnectSchemaUtil.toKsqlFieldSchema(schema.keySchema());
        ConnectSchemaUtil.checkMapKeyType(keySchema.type());
        return SchemaBuilder.map((Schema)Schema.OPTIONAL_STRING_SCHEMA, (Schema)ConnectSchemaUtil.toKsqlFieldSchema(schema.valueSchema())).optional().build();
    }

    private static Schema toKsqlArraySchema(Schema schema) {
        return SchemaBuilder.array((Schema)ConnectSchemaUtil.toKsqlFieldSchema(schema.valueSchema())).optional().build();
    }

    private static Schema toKsqlStructSchema(Schema schema) {
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        for (Field field : schema.fields()) {
            try {
                Schema fieldSchema = ConnectSchemaUtil.toKsqlFieldSchema(field.schema());
                schemaBuilder.field(field.name().toUpperCase(), fieldSchema);
            }
            catch (UnsupportedTypeException e) {
                log.error("Error inferring schema at field {}: {}", (Object)field.name(), (Object)e.getMessage());
            }
        }
        return schemaBuilder.optional().build();
    }

    private static class UnsupportedTypeException
    extends RuntimeException {
        UnsupportedTypeException(String error) {
            super(error);
        }
    }
}

