/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.connect;

import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.serde.connect.DataTranslator;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.storage.Converter;

public class KsqlConnectSerializer<T>
implements Serializer<T> {
    private final Schema schema;
    private final DataTranslator translator;
    private final Converter converter;

    public KsqlConnectSerializer(Schema schema, DataTranslator translator, Converter converter, Class<T> targetType) {
        this.schema = Objects.requireNonNull(schema, "schema");
        this.translator = Objects.requireNonNull(translator, "translator");
        this.converter = Objects.requireNonNull(converter, "converter");
        SerdeUtils.throwOnSchemaJavaTypeMismatch(schema, targetType);
    }

    public byte[] serialize(String topic, T data) {
        if (data == null) {
            return null;
        }
        try {
            Object connectRow = this.translator.toConnectRow(data);
            return this.converter.fromConnectData(topic, this.schema, connectRow);
        }
        catch (Exception e) {
            throw new SerializationException("Error serializing message to topic: " + topic + ". " + e.getMessage(), (Throwable)e);
        }
    }

    public void configure(Map<String, ?> map, boolean b) {
    }

    public void close() {
    }
}

