/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.delimited;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;

class KsqlDelimitedDeserializer
implements Deserializer<List<?>> {
    private static final Map<SqlBaseType, ParserFactory> PARSERS = ImmutableMap.builder().put((Object)SqlBaseType.BOOLEAN, t -> Boolean::parseBoolean).put((Object)SqlBaseType.INTEGER, t -> Integer::parseInt).put((Object)SqlBaseType.BIGINT, t -> Long::parseLong).put((Object)SqlBaseType.DOUBLE, t -> Double::parseDouble).put((Object)SqlBaseType.STRING, t -> v -> v).put((Object)SqlBaseType.DECIMAL, KsqlDelimitedDeserializer::decimalParser).build();
    private final CSVFormat csvFormat;
    private final List<Parser> parsers;

    KsqlDelimitedDeserializer(PersistenceSchema schema, CSVFormat csvFormat) {
        this.csvFormat = Objects.requireNonNull(csvFormat, "csvFormat");
        this.parsers = KsqlDelimitedDeserializer.buildParsers(schema);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public List<?> deserialize(String topic, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            String recordCsvString = new String(bytes, StandardCharsets.UTF_8);
            List csvRecords = CSVParser.parse((String)recordCsvString, (CSVFormat)this.csvFormat).getRecords();
            if (csvRecords.isEmpty()) {
                throw new SerializationException("No fields in record");
            }
            CSVRecord csvRecord = (CSVRecord)csvRecords.get(0);
            if (csvRecord == null || csvRecord.size() == 0) {
                throw new SerializationException("No fields in record.");
            }
            SerdeUtils.throwOnColumnCountMismatch(this.parsers.size(), csvRecord.size(), false, topic);
            ArrayList<Object> values = new ArrayList<Object>(this.parsers.size());
            Iterator<Parser> pIt = this.parsers.iterator();
            for (int i = 0; i < csvRecord.size(); ++i) {
                String value = csvRecord.get(i);
                Parser parser = pIt.next();
                Object parsed = value == null || value.isEmpty() ? null : parser.parse(value);
                values.add(parsed);
            }
            return values;
        }
        catch (Exception e) {
            throw new SerializationException("Error deserializing delimited", (Throwable)e);
        }
    }

    public void close() {
    }

    private static Parser decimalParser(SqlType sqlType) {
        SqlDecimal decimalType = (SqlDecimal)sqlType;
        return v -> DecimalUtil.ensureFit((BigDecimal)new BigDecimal(v), (SqlDecimal)decimalType);
    }

    private static List<Parser> buildParsers(PersistenceSchema schema) {
        ArrayList<Parser> parsers = new ArrayList<Parser>(schema.columns().size());
        for (SimpleColumn column : schema.columns()) {
            SqlBaseType baseType = column.type().baseType();
            ParserFactory parserFactory = PARSERS.get(baseType);
            if (parserFactory == null) {
                throw new KsqlException("The '" + FormatFactory.DELIMITED.name() + "' format does not support type '" + baseType + "', column: " + column.name());
            }
            parsers.add(parserFactory.build(column.type()));
        }
        return parsers;
    }

    private static interface ParserFactory {
        public Parser build(SqlType var1);
    }

    private static interface Parser {
        public Object parse(String var1);
    }
}

