/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.delimited;

import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

class KsqlDelimitedSerializer
implements Serializer<List<?>> {
    private final PersistenceSchema schema;
    private final CSVFormat csvFormat;

    KsqlDelimitedSerializer(PersistenceSchema schema, CSVFormat csvFormat) {
        this.schema = Objects.requireNonNull(schema, "schema");
        this.csvFormat = Objects.requireNonNull(csvFormat, "csvFormat");
    }

    public void configure(Map<String, ?> map, boolean b) {
    }

    public byte[] serialize(String topic, List<?> data) {
        if (data == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, this.csvFormat);
            csvPrinter.printRecord(() -> new FieldIterator(data, this.schema));
            String result = stringWriter.toString();
            return result.substring(0, result.length() - 2).getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SerializationException("Error serializing CSV message", (Throwable)e);
        }
    }

    public void close() {
    }

    private static class FieldIterator
    implements Iterator<Object> {
        private final Iterator<?> dataIt;
        private final Iterator<SimpleColumn> columnIt;

        FieldIterator(List<?> data, PersistenceSchema schema) {
            this.dataIt = data.iterator();
            this.columnIt = schema.columns().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.columnIt.hasNext();
        }

        @Override
        public Object next() {
            Object value = this.dataIt.next();
            SimpleColumn column = this.columnIt.next();
            return column.type().baseType().equals((Object)SqlBaseType.DECIMAL) ? FieldIterator.handleDecimal((BigDecimal)value) : value;
        }

        private static String handleDecimal(BigDecimal value) {
            return value.toPlainString();
        }
    }
}

