/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.json;

import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.connect.ConnectFormat;
import io.confluent.ksql.serde.connect.ConnectSchemaTranslator;
import io.confluent.ksql.serde.json.KsqlJsonSerdeFactory;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.connect.data.ConnectSchema;

public class JsonFormat
extends ConnectFormat {
    private static final ImmutableSet<SerdeFeature> SUPPORTED_FEATURES = ImmutableSet.of((Object)SerdeFeature.WRAP_SINGLES, (Object)SerdeFeature.UNWRAP_SINGLES);
    public static final String NAME = "JSON";

    @Override
    public Set<SerdeFeature> supportedFeatures() {
        return SUPPORTED_FEATURES;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    protected ConnectSchemaTranslator getConnectSchemaTranslator(Map<String, String> formatProps) {
        throw new UnsupportedOperationException(this.name() + " does not implement Schema Registry support");
    }

    @Override
    protected <T> Serde<T> getConnectSerde(ConnectSchema connectSchema, Map<String, String> formatProps, KsqlConfig config, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        return new KsqlJsonSerdeFactory(false).createSerde(connectSchema, config, srFactory, targetType, isKey);
    }
}

