/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.json;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.connect.json.JsonSchemaConverter;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.serde.connect.ConnectDataTranslator;
import io.confluent.ksql.serde.connect.KsqlConnectSerializer;
import io.confluent.ksql.serde.json.KsqlJsonDeserializer;
import io.confluent.ksql.serde.tls.ThreadLocalSerializer;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.json.DecimalFormat;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.storage.Converter;

@Immutable
class KsqlJsonSerdeFactory {
    private final boolean useSchemaRegistryFormat;

    KsqlJsonSerdeFactory(boolean useSchemaRegistryFormat) {
        this.useSchemaRegistryFormat = useSchemaRegistryFormat;
    }

    <T> Serde<T> createSerde(ConnectSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        Supplier serializer = () -> this.createSerializer(schema, ksqlConfig, srFactory, targetType, isKey);
        Deserializer<T> deserializer = this.createDeserializer(schema, targetType);
        serializer.get();
        return Serdes.serdeFrom(new ThreadLocalSerializer(serializer), deserializer);
    }

    private <T> Serializer<T> createSerializer(ConnectSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        Converter converter = this.useSchemaRegistryFormat ? KsqlJsonSerdeFactory.getSchemaConverter(srFactory.get(), ksqlConfig, isKey) : KsqlJsonSerdeFactory.getConverter();
        return new KsqlConnectSerializer<T>((Schema)schema, new ConnectDataTranslator((Schema)schema), converter, targetType);
    }

    private <T> Deserializer<T> createDeserializer(ConnectSchema schema, Class<T> targetType) {
        return new KsqlJsonDeserializer<T>(schema, this.useSchemaRegistryFormat, targetType);
    }

    private static Converter getConverter() {
        JsonConverter converter = new JsonConverter();
        converter.configure((Map)ImmutableMap.of((Object)"schemas.enable", (Object)false, (Object)"decimal.format", (Object)DecimalFormat.NUMERIC.name()), false);
        return converter;
    }

    private static Converter getSchemaConverter(SchemaRegistryClient schemaRegistryClient, KsqlConfig ksqlConfig, boolean isKey) {
        Map config = ksqlConfig.originalsWithPrefix("ksql.schema.registry.");
        config.put("schema.registry.url", ksqlConfig.getString("ksql.schema.registry.url"));
        config.put("decimal.format", DecimalFormat.NUMERIC.name());
        JsonSchemaConverter converter = new JsonSchemaConverter(schemaRegistryClient);
        converter.configure(config, isKey);
        return converter;
    }
}

