/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.kafka;

import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatProperties;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.serde.kafka.KafkaSerdeFactory;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;

public class KafkaFormat
implements Format {
    private static final ImmutableSet<SerdeFeature> SUPPORTED_FEATURES = ImmutableSet.of((Object)SerdeFeature.UNWRAP_SINGLES);
    public static final String NAME = "KAFKA";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Set<SerdeFeature> supportedFeatures() {
        return SUPPORTED_FEATURES;
    }

    @Override
    public Serde<List<?>> getSerde(PersistenceSchema schema, Map<String, String> formatProperties, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srClientFactory, boolean isKey) {
        FormatProperties.validateProperties(this.name(), formatProperties, this.getSupportedProperties());
        SerdeUtils.throwOnUnsupportedFeatures(schema.features(), this.supportedFeatures());
        return KafkaSerdeFactory.createSerde(schema);
    }
}

