/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.serde.FormatFactory;
import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.serde.voids.KsqlVoidSerde;
import io.confluent.ksql.util.KsqlException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public final class KafkaSerdeFactory {
    private static final ImmutableMap<Class<?>, Serde<?>> SERDE = ImmutableMap.of(Integer.class, (Object)Serdes.Integer(), Long.class, (Object)Serdes.Long(), Double.class, (Object)Serdes.Double(), String.class, (Object)Serdes.String());

    private KafkaSerdeFactory() {
    }

    static Serde<List<?>> createSerde(PersistenceSchema schema) {
        List columns = schema.columns();
        if (columns.isEmpty()) {
            return new KsqlVoidSerde();
        }
        if (columns.size() != 1) {
            throw new KsqlException("The '" + FormatFactory.KAFKA.name() + "' format only supports a single field. Got: " + columns);
        }
        SimpleColumn singleColumn = (SimpleColumn)columns.get(0);
        Class javaType = SchemaConverters.sqlToJavaConverter().toJavaType(singleColumn.type());
        return KafkaSerdeFactory.createSerde(singleColumn, javaType);
    }

    private static <T> Serde<List<?>> createSerde(SimpleColumn singleColumn, Class<T> javaType) {
        Serde<T> primitiveSerde = KafkaSerdeFactory.getPrimitiveSerde(singleColumn.type().baseType(), javaType);
        RowSerializer<T> serializer = new RowSerializer<T>(primitiveSerde.serializer(), javaType);
        RowDeserializer deserializer = new RowDeserializer(primitiveSerde.deserializer());
        return Serdes.serdeFrom(serializer, (Deserializer)deserializer);
    }

    @VisibleForTesting
    public static <T> Serde<T> getPrimitiveSerde(SqlBaseType sqlType, Class<T> javaType) {
        Serde serde = (Serde)SERDE.get(javaType);
        if (serde == null) {
            throw new KsqlException("The '" + FormatFactory.KAFKA.name() + "' format does not support type '" + sqlType + "'");
        }
        return serde;
    }

    private static final class RowDeserializer
    implements Deserializer<List<?>> {
        private final Deserializer<?> delegate;

        RowDeserializer(Deserializer<?> delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
        }

        public List<?> deserialize(String topic, byte[] bytes) {
            try {
                Object primitive = this.delegate.deserialize(topic, bytes);
                if (primitive == null) {
                    return null;
                }
                return Collections.singletonList(primitive);
            }
            catch (Exception e) {
                throw new SerializationException("Error deserializing KAFKA message from topic: " + topic, (Throwable)e);
            }
        }
    }

    private static final class RowSerializer<T>
    implements Serializer<List<?>> {
        private final Serializer<T> delegate;
        private final Class<T> javaType;

        RowSerializer(Serializer<T> delegate, Class<T> javaType) {
            this.delegate = Objects.requireNonNull(delegate, "delegate");
            this.javaType = Objects.requireNonNull(javaType, "javaType");
        }

        public byte[] serialize(String topic, List<?> values) {
            if (values == null) {
                return null;
            }
            SerdeUtils.throwOnColumnCountMismatch(1, values.size(), true, topic);
            T value = SerdeUtils.safeCast(values.get(0), this.javaType);
            return this.delegate.serialize(topic, value);
        }
    }
}

