/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.protobuf;

import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.serde.FormatProperties;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.connect.ConnectFormat;
import io.confluent.ksql.serde.connect.ConnectSchemaTranslator;
import io.confluent.ksql.serde.protobuf.ProtobufSchemaTranslator;
import io.confluent.ksql.serde.protobuf.ProtobufSerdeFactory;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.connect.data.ConnectSchema;

public class ProtobufFormat
extends ConnectFormat {
    static final ImmutableSet<SerdeFeature> SUPPORTED_FEATURES = ImmutableSet.of((Object)SerdeFeature.SCHEMA_INFERENCE, (Object)SerdeFeature.WRAP_SINGLES);
    public static final String NAME = "PROTOBUF";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Set<SerdeFeature> supportedFeatures() {
        return SUPPORTED_FEATURES;
    }

    @Override
    protected ConnectSchemaTranslator getConnectSchemaTranslator(Map<String, String> formatProps) {
        FormatProperties.validateProperties(this.name(), formatProps, (Set<String>)ImmutableSet.of());
        return new ProtobufSchemaTranslator();
    }

    @Override
    protected <T> Serde<T> getConnectSerde(ConnectSchema connectSchema, Map<String, String> formatProps, KsqlConfig config, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        return ProtobufSerdeFactory.createSerde(connectSchema, config, srFactory, targetType);
    }
}

