/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.protobuf;

import io.confluent.connect.protobuf.ProtobufConverter;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.connect.SchemaWalker;
import io.confluent.ksql.serde.connect.ConnectDataTranslator;
import io.confluent.ksql.serde.connect.KsqlConnectDeserializer;
import io.confluent.ksql.serde.connect.KsqlConnectSerializer;
import io.confluent.ksql.serde.tls.ThreadLocalDeserializer;
import io.confluent.ksql.serde.tls.ThreadLocalSerializer;
import io.confluent.ksql.util.DecimalUtil;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.storage.Converter;

final class ProtobufSerdeFactory {
    private ProtobufSerdeFactory() {
    }

    static <T> Serde<T> createSerde(ConnectSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType) {
        ProtobufSerdeFactory.validate((Schema)schema);
        Supplier serializer = () -> ProtobufSerdeFactory.createSerializer(schema, ksqlConfig, srFactory, targetType);
        Supplier deserializer = () -> ProtobufSerdeFactory.createDeserializer(schema, ksqlConfig, srFactory, targetType);
        serializer.get();
        deserializer.get();
        return Serdes.serdeFrom(new ThreadLocalSerializer(serializer), new ThreadLocalDeserializer(deserializer));
    }

    private static void validate(Schema schema) {
        SchemaWalker.visit((Schema)schema, (SchemaWalker.Visitor)new SchemaValidator());
    }

    private static <T> KsqlConnectSerializer<T> createSerializer(ConnectSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType) {
        ProtobufConverter converter = ProtobufSerdeFactory.getConverter(srFactory.get(), ksqlConfig);
        return new KsqlConnectSerializer<T>((Schema)schema, new ConnectDataTranslator((Schema)schema), (Converter)converter, targetType);
    }

    private static <T> KsqlConnectDeserializer<T> createDeserializer(ConnectSchema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType) {
        ProtobufConverter converter = ProtobufSerdeFactory.getConverter(srFactory.get(), ksqlConfig);
        return new KsqlConnectDeserializer<T>((Converter)converter, new ConnectDataTranslator((Schema)schema), targetType);
    }

    private static ProtobufConverter getConverter(SchemaRegistryClient schemaRegistryClient, KsqlConfig ksqlConfig) {
        Map protobufConfig = ksqlConfig.originalsWithPrefix("ksql.schema.registry.");
        protobufConfig.put("schema.registry.url", ksqlConfig.getString("ksql.schema.registry.url"));
        ProtobufConverter converter = new ProtobufConverter(schemaRegistryClient);
        converter.configure(protobufConfig, false);
        return converter;
    }

    private static class SchemaValidator
    implements SchemaWalker.Visitor<Void, Void> {
        private SchemaValidator() {
        }

        public Void visitBytes(Schema schema) {
            if (DecimalUtil.isDecimal((Schema)schema)) {
                throw new KsqlException("The 'PROTOBUF' format does not support type 'DECIMAL'. See https://github.com/confluentinc/ksql/issues/5762.");
            }
            return null;
        }

        public Void visitMap(Schema schema, Void key, Void value) {
            if (schema.keySchema().type() != Schema.Type.STRING) {
                throw new KsqlException("PROTOBUF format only supports MAP types with STRING keys. See https://github.com/confluentinc/ksql/issues/6177.");
            }
            return null;
        }

        public Void visitSchema(Schema schema) {
            return null;
        }
    }
}

