/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.function.TableAggregationFunction;
import io.confluent.ksql.execution.function.UdafUtil;
import io.confluent.ksql.execution.function.udaf.KudafAggregator;
import io.confluent.ksql.execution.function.udaf.KudafInitializer;
import io.confluent.ksql.execution.function.udaf.KudafUndoAggregator;
import io.confluent.ksql.execution.streams.AggregateParams;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.KsqlAggregateFunction;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.ColumnNames;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class AggregateParamsFactory {
    private final KudafAggregatorFactory aggregatorFactory;
    private final KudafUndoAggregatorFactory undoAggregatorFactory;

    public AggregateParamsFactory() {
        this(KudafAggregator::new, KudafUndoAggregator::new);
    }

    @VisibleForTesting
    AggregateParamsFactory(KudafAggregatorFactory aggregatorFactory, KudafUndoAggregatorFactory undoAggregatorFactory) {
        this.aggregatorFactory = Objects.requireNonNull(aggregatorFactory);
        this.undoAggregatorFactory = Objects.requireNonNull(undoAggregatorFactory);
    }

    public AggregateParams createUndoable(LogicalSchema schema, List<ColumnName> nonAggregateColumns, FunctionRegistry functionRegistry, List<FunctionCall> functionList, KsqlConfig config) {
        return this.create(schema, nonAggregateColumns, functionRegistry, functionList, true, false, config);
    }

    public AggregateParams create(LogicalSchema schema, List<ColumnName> nonAggregateColumns, FunctionRegistry functionRegistry, List<FunctionCall> functionList, boolean windowedAggregation, KsqlConfig config) {
        return this.create(schema, nonAggregateColumns, functionRegistry, functionList, false, windowedAggregation, config);
    }

    private AggregateParams create(LogicalSchema schema, List<ColumnName> nonAggregateColumns, FunctionRegistry functionRegistry, List<FunctionCall> functionList, boolean table, boolean windowedAggregation, KsqlConfig config) {
        List<KsqlAggregateFunction<?, ?, ?>> functions = AggregateParamsFactory.resolveAggregateFunctions(schema, functionRegistry, functionList, config);
        List initialValueSuppliers = functions.stream().map(KsqlAggregateFunction::getInitialValueSupplier).collect(Collectors.toList());
        Optional<KudafUndoAggregator> undoAggregator = this.buildUndoAggregators(nonAggregateColumns.size(), table, functions);
        LogicalSchema aggregateSchema = AggregateParamsFactory.buildSchema(schema, nonAggregateColumns, functions, true, false);
        LogicalSchema outputSchema = AggregateParamsFactory.buildSchema(schema, nonAggregateColumns, functions, false, windowedAggregation);
        return new AggregateParams(new KudafInitializer(nonAggregateColumns.size(), initialValueSuppliers), this.aggregatorFactory.create(nonAggregateColumns.size(), functions), undoAggregator, aggregateSchema, outputSchema);
    }

    private Optional<KudafUndoAggregator> buildUndoAggregators(int nonAggColumnCount, boolean table, List<KsqlAggregateFunction<?, ?, ?>> functions) {
        if (!table) {
            return Optional.empty();
        }
        LinkedList tableFunctions = new LinkedList();
        for (KsqlAggregateFunction<?, ?, ?> function : functions) {
            tableFunctions.add((TableAggregationFunction)function);
        }
        return Optional.of(this.undoAggregatorFactory.create(nonAggColumnCount, tableFunctions));
    }

    private static List<KsqlAggregateFunction<?, ?, ?>> resolveAggregateFunctions(LogicalSchema schema, FunctionRegistry functionRegistry, List<FunctionCall> functionList, KsqlConfig config) {
        return ImmutableList.copyOf((Collection)functionList.stream().map(funcCall -> UdafUtil.resolveAggregateFunction((FunctionRegistry)functionRegistry, (FunctionCall)funcCall, (LogicalSchema)schema, (KsqlConfig)config)).collect(Collectors.toList()));
    }

    private static LogicalSchema buildSchema(LogicalSchema schema, List<ColumnName> nonAggregateColumns, List<KsqlAggregateFunction<?, ?, ?>> aggregateFunctions, boolean useAggregate, boolean addWindowBounds) {
        LogicalSchema.Builder schemaBuilder = LogicalSchema.builder();
        schemaBuilder.keyColumns((Iterable)schema.key());
        for (ColumnName columnName : nonAggregateColumns) {
            Column col = (Column)schema.findValueColumn(columnName).orElseThrow(IllegalArgumentException::new);
            schemaBuilder.valueColumn((SimpleColumn)col);
        }
        for (int i = 0; i < aggregateFunctions.size(); ++i) {
            KsqlAggregateFunction<?, ?, ?> aggregateFunction = aggregateFunctions.get(i);
            ColumnName colName = ColumnNames.aggregateColumn((int)i);
            SqlType fieldType = useAggregate ? aggregateFunction.getAggregateType() : aggregateFunction.returnType();
            schemaBuilder.valueColumn(colName, fieldType);
        }
        if (addWindowBounds) {
            schemaBuilder.valueColumn(SystemColumns.WINDOWSTART_NAME, SystemColumns.WINDOWBOUND_TYPE);
            schemaBuilder.valueColumn(SystemColumns.WINDOWEND_NAME, SystemColumns.WINDOWBOUND_TYPE);
        }
        return schemaBuilder.build();
    }

    static interface KudafUndoAggregatorFactory {
        public KudafUndoAggregator create(int var1, List<TableAggregationFunction<?, ?, ?>> var2);
    }

    static interface KudafAggregatorFactory {
        public KudafAggregator<?> create(int var1, List<KsqlAggregateFunction<?, ?, ?>> var2);
    }
}

