/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.StreamSelect;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.execution.streams.transform.KsTransformer;
import io.confluent.ksql.execution.streams.transform.KsValueTransformer;
import io.confluent.ksql.execution.transform.select.SelectValueMapper;
import io.confluent.ksql.execution.transform.select.Selection;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.streams.kstream.Named;

public final class StreamSelectBuilder {
    private StreamSelectBuilder() {
    }

    public static <K> KStreamHolder<K> build(KStreamHolder<K> stream, StreamSelect<K> step, RuntimeBuildContext buildContext) {
        QueryContext queryContext = step.getProperties().getQueryContext();
        LogicalSchema sourceSchema = stream.getSchema();
        Optional selectedKeys = step.getSelectedKeys();
        Selection selection = Selection.of((LogicalSchema)sourceSchema, (List)step.getKeyColumnNames(), (Optional)selectedKeys, (List)step.getSelectExpressions(), (KsqlConfig)buildContext.getKsqlConfig(), (FunctionRegistry)buildContext.getFunctionRegistry());
        ImmutableList.Builder keyIndexBuilder = ImmutableList.builder();
        if (selectedKeys.isPresent()) {
            ImmutableList keyNames = (ImmutableList)sourceSchema.key().stream().map(Column::name).collect(ImmutableList.toImmutableList());
            for (ColumnName keyName : (ImmutableList)selectedKeys.get()) {
                keyIndexBuilder.add((Object)keyNames.indexOf((Object)keyName));
            }
        }
        ImmutableList keyIndices = keyIndexBuilder.build();
        SelectValueMapper selectMapper = selection.getMapper();
        ProcessingLogger logger = buildContext.getProcessingLogger(queryContext);
        Named selectName = Named.as((String)StreamsUtil.buildOpName(queryContext));
        if (selectedKeys.isPresent() && !((ImmutableList)selectedKeys.get()).containsAll((Collection)sourceSchema.key().stream().map(Column::name).collect(ImmutableList.toImmutableList()))) {
            return stream.withStream(stream.getStream().transform(() -> new KsTransformer((readOnlyKey, value, ctx) -> {
                if (keyIndices.isEmpty()) {
                    return null;
                }
                if (readOnlyKey instanceof GenericKey) {
                    GenericKey keys = (GenericKey)readOnlyKey;
                    GenericKey.Builder resultKeys = GenericKey.builder((int)keyIndices.size());
                    UnmodifiableIterator unmodifiableIterator = keyIndices.iterator();
                    while (unmodifiableIterator.hasNext()) {
                        int keyIndex = (Integer)unmodifiableIterator.next();
                        resultKeys.append(keys.get(keyIndex));
                    }
                    return resultKeys.build();
                }
                throw new UnsupportedOperationException();
            }, selectMapper.getTransformer(logger)), selectName, new String[0]), selection.getSchema());
        }
        return stream.withStream(stream.getStream().transformValues(() -> new KsValueTransformer(selectMapper.getTransformer(logger)), selectName, new String[0]), selection.getSchema());
    }
}

