/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.execution.runtime.MaterializedFactory;
import io.confluent.ksql.execution.streams.ConsumedFactory;
import io.confluent.ksql.execution.streams.GroupedFactory;
import io.confluent.ksql.execution.streams.JoinedFactory;
import io.confluent.ksql.execution.streams.StreamJoinedFactory;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Objects;
import org.apache.kafka.streams.kstream.Consumed;

public class StreamsFactories {
    private final GroupedFactory groupedFactory;
    private final JoinedFactory joinedFactory;
    private final MaterializedFactory materializedFactory;
    private final StreamJoinedFactory streamJoinedFactory;
    private final ConsumedFactory consumedFactory;

    public static StreamsFactories create(KsqlConfig ksqlConfig) {
        Objects.requireNonNull(ksqlConfig);
        return new StreamsFactories(GroupedFactory.create(), JoinedFactory.create(), new MaterializedFactory(), StreamJoinedFactory.create(), Consumed::with);
    }

    public StreamsFactories(GroupedFactory groupedFactory, JoinedFactory joinedFactory, MaterializedFactory materializedFactory, StreamJoinedFactory streamJoinedFactory, ConsumedFactory consumedFactory) {
        this.groupedFactory = Objects.requireNonNull(groupedFactory);
        this.joinedFactory = Objects.requireNonNull(joinedFactory);
        this.materializedFactory = Objects.requireNonNull(materializedFactory);
        this.streamJoinedFactory = Objects.requireNonNull(streamJoinedFactory);
        this.consumedFactory = Objects.requireNonNull(consumedFactory);
    }

    public GroupedFactory getGroupedFactory() {
        return this.groupedFactory;
    }

    public JoinedFactory getJoinedFactory() {
        return this.joinedFactory;
    }

    public MaterializedFactory getMaterializedFactory() {
        return this.materializedFactory;
    }

    public StreamJoinedFactory getStreamJoinedFactory() {
        return this.streamJoinedFactory;
    }

    public ConsumedFactory getConsumedFactory() {
        return this.consumedFactory;
    }
}

