/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.execution.materialization.MaterializationInfo;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.execution.plan.KGroupedTableHolder;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.TableAggregate;
import io.confluent.ksql.execution.runtime.MaterializedFactory;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.AggregateBuilderUtils;
import io.confluent.ksql.execution.streams.AggregateParams;
import io.confluent.ksql.execution.streams.AggregateParamsFactory;
import io.confluent.ksql.execution.streams.MaterializationUtil;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.execution.streams.transform.KsValueTransformer;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.List;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;

public final class TableAggregateBuilder {
    private TableAggregateBuilder() {
    }

    public static KTableHolder<GenericKey> build(KGroupedTableHolder groupedTable, TableAggregate aggregate, RuntimeBuildContext buildContext, MaterializedFactory materializedFactory) {
        return TableAggregateBuilder.build(groupedTable, aggregate, buildContext, materializedFactory, new AggregateParamsFactory());
    }

    public static KTableHolder<GenericKey> build(KGroupedTableHolder groupedTable, TableAggregate aggregate, RuntimeBuildContext buildContext, MaterializedFactory materializedFactory, AggregateParamsFactory aggregateParamsFactory) {
        LogicalSchema sourceSchema = groupedTable.getSchema();
        List nonFuncColumns = aggregate.getNonAggregateColumns();
        AggregateParams aggregateParams = aggregateParamsFactory.createUndoable(sourceSchema, nonFuncColumns, buildContext.getFunctionRegistry(), aggregate.getAggregationFunctions(), buildContext.getKsqlConfig());
        LogicalSchema aggregateSchema = aggregateParams.getAggregateSchema();
        LogicalSchema resultSchema = aggregateParams.getSchema();
        Materialized materialized = MaterializationUtil.buildMaterialized(aggregate, aggregateSchema, aggregate.getInternalFormats(), buildContext, materializedFactory, ExecutionKeyFactory.unwindowed((RuntimeBuildContext)buildContext));
        KTable aggregated = groupedTable.getGroupedTable().aggregate((Initializer)aggregateParams.getInitializer(), aggregateParams.getAggregator(), (Aggregator)aggregateParams.getUndoAggregator().get(), materialized).transformValues(() -> new KsValueTransformer(aggregateParams.getAggregator().getResultMapper()), Named.as((String)StreamsUtil.buildOpName(AggregateBuilderUtils.outputContext(aggregate))), new String[0]);
        MaterializationInfo.Builder materializationBuilder = AggregateBuilderUtils.materializationInfoBuilder(aggregateParams.getAggregator(), aggregate, aggregateSchema, resultSchema);
        return KTableHolder.materialized((KTable)aggregated, (LogicalSchema)resultSchema, (ExecutionKeyFactory)ExecutionKeyFactory.unwindowed((RuntimeBuildContext)buildContext), (MaterializationInfo.Builder)materializationBuilder);
    }
}

