/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.timestamp;

import com.google.common.base.Preconditions;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.streams.timestamp.ColumnExtractor;
import io.confluent.ksql.schema.ksql.Column;
import org.apache.kafka.streams.kstream.Windowed;

final class TimestampColumnExtractors {
    private TimestampColumnExtractors() {
    }

    static ColumnExtractor create(Column column) {
        int index = column.index();
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)("negative index: " + index));
        return column.namespace() == Column.Namespace.KEY ? new KeyColumnExtractor(index) : new ValueColumnExtractor(index);
    }

    private static class ValueColumnExtractor
    implements ColumnExtractor {
        private final int index;

        ValueColumnExtractor(int index) {
            this.index = index;
        }

        @Override
        public Object extract(Object key, GenericRow value) {
            return value.get(this.index);
        }
    }

    private static class KeyColumnExtractor
    implements ColumnExtractor {
        private final int index;

        KeyColumnExtractor(int index) {
            this.index = index;
        }

        @Override
        public Object extract(Object key, GenericRow value) {
            GenericKey genericKey = KeyColumnExtractor.getGenericKey(key);
            return genericKey.get(this.index);
        }

        private static GenericKey getGenericKey(Object key) {
            if (key instanceof Windowed) {
                Windowed windowed = (Windowed)key;
                return (GenericKey)windowed.key();
            }
            return (GenericKey)key;
        }
    }
}

