/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics;

import io.confluent.support.metrics.BaseSupportConfig;
import io.confluent.support.metrics.common.Collector;
import io.confluent.support.metrics.serde.AvroSerializer;
import io.confluent.support.metrics.submitters.ConfluentSubmitter;
import io.confluent.support.metrics.submitters.ResponseHandler;
import io.confluent.support.metrics.submitters.Submitter;
import io.confluent.support.metrics.utils.Jitter;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import org.apache.avro.generic.GenericContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetricsReporter
extends Thread
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(BaseMetricsReporter.class);
    protected static final long RETENTION_MS = 31536000000L;
    public static final int SUPPORT_TOPIC_REPLICATION = 3;
    protected static final int SUPPORT_TOPIC_PARTITIONS = 1;
    private static final long SETTLING_TIME_MS = 10000L;
    private final boolean enableSettlingTime;
    private String customerId;
    private long reportIntervalMs;
    private Submitter confluentSubmitter;
    private Collector metricsCollector;
    private final AvroSerializer encoder = new AvroSerializer();
    protected final BaseSupportConfig supportConfig;
    private final ResponseHandler responseHandler;
    private volatile boolean isClosing = false;

    public BaseMetricsReporter(String threadName, boolean isDaemon, BaseSupportConfig serverConfiguration) {
        this(threadName, isDaemon, serverConfiguration, null, true);
    }

    public BaseMetricsReporter(String threadName, boolean isDaemon, BaseSupportConfig supportConfig, ResponseHandler responseHandler, boolean enableSettlingTime) {
        super(threadName);
        this.setDaemon(isDaemon);
        Objects.requireNonNull(supportConfig, "supportConfig can't be null");
        this.supportConfig = supportConfig;
        this.responseHandler = responseHandler;
        this.enableSettlingTime = enableSettlingTime;
    }

    public void init() {
        this.customerId = this.supportConfig.getCustomerId();
        this.metricsCollector = this.metricsCollector();
        this.metricsCollector.setRuntimeState(Collector.RuntimeState.Running);
        this.reportIntervalMs = this.supportConfig.getReportIntervalMs();
        String endpointHttp = this.supportConfig.getEndpointHttp();
        String endpointHttps = this.supportConfig.getEndpointHttps();
        String proxyURI = this.supportConfig.getProxy();
        this.confluentSubmitter = !endpointHttp.isEmpty() || !endpointHttps.isEmpty() ? new ConfluentSubmitter(this.customerId, endpointHttp, endpointHttps, proxyURI, this.responseHandler) : null;
        if (!this.reportingEnabled()) {
            log.info("Metrics collection disabled by component configuration");
        }
    }

    protected abstract Collector metricsCollector();

    protected boolean reportingEnabled() {
        return this.sendToConfluentEnabled();
    }

    protected boolean sendToConfluentEnabled() {
        return this.confluentSubmitter != null;
    }

    @Override
    public void run() {
        try {
            if (this.reportingEnabled()) {
                this.waitForServer();
                while (!this.isClosing) {
                    log.info("Attempting to collect and submit metrics");
                    this.submitMetrics();
                    Thread.sleep(Jitter.addOnePercentJitter(this.reportIntervalMs));
                }
            }
        }
        catch (InterruptedException e) {
            log.error("Caught InterruptedException during metrics collection", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("Caught exception during metrics collection", (Throwable)e);
        }
        finally {
            if (this.isClosing) {
                log.info("Gracefully terminating metrics collection");
                this.metricsCollector.setRuntimeState(Collector.RuntimeState.ShuttingDown);
                this.submitMetrics();
            }
            log.info("Metrics collection stopped");
        }
    }

    @Override
    public void close() {
        log.info("Closing BaseMetricsReporter");
        this.isClosing = true;
        this.interrupt();
    }

    private void waitForServer() throws InterruptedException {
        log.info("Waiting until monitored service is ready for metrics collection");
        while (!(this.isClosing || this.isReadyForMetricsCollection() || this.isShuttingDown())) {
            if (!this.enableSettlingTime) continue;
            long waitTimeMs = Jitter.addOnePercentJitter(10000L);
            log.info("Waiting {} ms for the monitored service to finish starting up", (Object)waitTimeMs);
            Thread.sleep(waitTimeMs);
        }
        if (this.isShuttingDown()) {
            this.close();
        } else {
            log.info("Monitored service is now ready");
        }
    }

    protected abstract boolean isReadyForMetricsCollection();

    protected abstract boolean isShuttingDown();

    void submitMetrics() {
        byte[] encodedMetricsRecord = null;
        GenericContainer metricsRecord = this.metricsCollector.collectMetrics();
        try {
            encodedMetricsRecord = this.encoder.serialize(metricsRecord);
        }
        catch (IOException e) {
            log.error("Could not serialize metrics record: {}", (Object)e.toString());
        }
        try {
            if (this.sendToConfluentEnabled() && encodedMetricsRecord != null) {
                this.confluentSubmitter.submit(encodedMetricsRecord);
            }
        }
        catch (RuntimeException e) {
            log.error("Could not submit metrics to Confluent: {}", (Object)e.getMessage());
        }
    }
}

