/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics.utils;

import io.confluent.support.metrics.submitters.ResponseHandler;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebClient {
    private static final Logger log = LoggerFactory.getLogger(WebClient.class);
    private static final int REQUEST_TIMEOUT_MS = 2000;
    public static final int DEFAULT_STATUS_CODE = 502;

    private WebClient() {
        throw new IllegalStateException("Utility class should not be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int send(String customerId, byte[] bytes, HttpPost httpPost, HttpHost proxy, CloseableHttpClient httpClient, ResponseHandler responseHandler) {
        int statusCode = 502;
        if (bytes != null && bytes.length > 0 && httpPost != null && customerId != null) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addTextBody("cid", customerId);
            builder.addBinaryBody("file", bytes, ContentType.DEFAULT_BINARY, "filename");
            httpPost.setEntity(builder.build());
            httpPost.addHeader("api-version", "phone-home-v1");
            RequestConfig config = RequestConfig.custom().setConnectTimeout(2000).setConnectionRequestTimeout(2000).setSocketTimeout(2000).build();
            CloseableHttpResponse response = null;
            try {
                if (proxy != null) {
                    log.debug("setting proxy to {}", (Object)proxy);
                    config = RequestConfig.copy((RequestConfig)config).setProxy(proxy).build();
                    httpPost.setConfig(config);
                    DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
                    if (httpClient == null) {
                        httpClient = HttpClientBuilder.create().setRoutePlanner((HttpRoutePlanner)routePlanner).setDefaultRequestConfig(config).build();
                    }
                } else if (httpClient == null) {
                    httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
                }
                response = httpClient.execute((HttpUriRequest)httpPost);
                if (responseHandler != null) {
                    responseHandler.handle((HttpResponse)response);
                }
                log.debug("POST request returned {}", (Object)response.getStatusLine().toString());
                statusCode = response.getStatusLine().getStatusCode();
            }
            catch (IOException e) {
                log.error("Could not submit metrics to Confluent: {}", (Object)e.getMessage());
            }
            finally {
                if (httpClient != null) {
                    try {
                        httpClient.close();
                    }
                    catch (IOException e) {
                        log.warn("could not close http client", (Throwable)e);
                    }
                }
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        log.warn("could not close http response", (Throwable)e);
                    }
                }
            }
        } else {
            statusCode = 400;
        }
        return statusCode;
    }

    public static int send(String customerId, byte[] bytes, HttpPost httpPost, HttpHost proxy, ResponseHandler responseHandler) {
        return WebClient.send(customerId, bytes, httpPost, proxy, null, responseHandler);
    }

    public static int send(String customerId, byte[] bytes, HttpPost httpPost, ResponseHandler responseHandler) {
        return WebClient.send(customerId, bytes, httpPost, null, responseHandler);
    }
}

