/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics.common;

public enum CollectorType {
    BASIC(0, "basic"),
    FULL(1, "full");

    public final int id;
    public final String name;

    private CollectorType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static CollectorType forId(int id) {
        switch (id) {
            case 0: {
                return BASIC;
            }
            case 1: {
                return FULL;
            }
        }
        throw new IllegalArgumentException("Unknown collector type id: " + id);
    }

    public static CollectorType forName(String name) {
        if (CollectorType.BASIC.name.equals(name)) {
            return BASIC;
        }
        if (CollectorType.FULL.name.equals(name)) {
            return FULL;
        }
        throw new IllegalArgumentException("Unknown collector name: " + name);
    }
}

