/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.support.metrics.submitters;

import io.confluent.support.metrics.BaseSupportConfig;
import io.confluent.support.metrics.submitters.ResponseHandler;
import io.confluent.support.metrics.submitters.Submitter;
import io.confluent.support.metrics.utils.StringUtils;
import io.confluent.support.metrics.utils.WebClient;
import java.net.URI;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.core5.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentSubmitter
implements Submitter {
    private static final Logger log = LoggerFactory.getLogger(ConfluentSubmitter.class);
    private final String customerId;
    private final String endpointHttp;
    private final String endpointHttps;
    private HttpHost proxy;
    private ResponseHandler responseHandler;

    public String getProxy() {
        return this.proxy == null ? null : this.proxy.toString();
    }

    public void setProxy(String name, int port, String scheme) {
        this.proxy = new HttpHost(scheme, name, port);
    }

    public ConfluentSubmitter(String customerId, String endpointHttp, String endpointHttps) {
        this(customerId, endpointHttp, endpointHttps, null, null);
    }

    public ConfluentSubmitter(String componentId, ResponseHandler responseHandler) {
        this("anonymous", componentId, responseHandler);
    }

    public ConfluentSubmitter(String customerId, String componentId, ResponseHandler responseHandler) {
        this(customerId, BaseSupportConfig.getEndpoint(false, customerId, componentId), BaseSupportConfig.getEndpoint(true, customerId, componentId), "", responseHandler);
    }

    public ConfluentSubmitter(String customerId, String endpointHttp, String endpointHttps, String proxyUriString, ResponseHandler responseHandler) {
        if (StringUtils.isNullOrEmpty(endpointHttp) && StringUtils.isNullOrEmpty(endpointHttps)) {
            throw new IllegalArgumentException("must specify endpoints");
        }
        if (!StringUtils.isNullOrEmpty(endpointHttp) && !endpointHttp.startsWith("http://")) {
            throw new IllegalArgumentException("invalid HTTP endpoint " + endpointHttp);
        }
        if (!StringUtils.isNullOrEmpty(endpointHttps) && !endpointHttps.startsWith("https://")) {
            throw new IllegalArgumentException("invalid HTTPS endpoint " + endpointHttps);
        }
        if (!BaseSupportConfig.isSyntacticallyCorrectCustomerId(customerId)) {
            throw new IllegalArgumentException("invalid customer ID " + customerId);
        }
        this.endpointHttp = endpointHttp;
        this.endpointHttps = endpointHttps;
        this.customerId = customerId;
        this.responseHandler = responseHandler;
        if (!StringUtils.isNullOrEmpty(proxyUriString)) {
            URI proxyUri = URI.create(proxyUriString);
            this.setProxy(proxyUri.getHost(), proxyUri.getPort(), proxyUri.getScheme());
        }
    }

    @Override
    public void submit(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            if (this.isSecureEndpointEnabled()) {
                if (!this.submittedSuccessfully(this.sendSecurely(bytes))) {
                    if (this.isInsecureEndpointEnabled()) {
                        log.error("Failed to submit metrics via secure endpoint, falling back to insecure endpoint");
                        this.submitToInsecureEndpoint(bytes);
                    } else {
                        log.error("Failed to submit metrics via secure endpoint={} -- giving up", (Object)this.endpointHttps);
                    }
                } else {
                    log.info("Successfully submitted metrics to Confluent via secure endpoint");
                }
            } else if (this.isInsecureEndpointEnabled()) {
                this.submitToInsecureEndpoint(bytes);
            } else {
                log.error("Metrics will not be submitted because all endpoints are disabled");
            }
        } else {
            log.error("Could not submit metrics to Confluent (metrics data missing)");
        }
    }

    private void submitToInsecureEndpoint(byte[] encodedMetricsRecord) {
        int statusCode = this.sendInsecurely(encodedMetricsRecord);
        if (this.submittedSuccessfully(statusCode)) {
            log.info("Successfully submitted metrics to Confluent via insecure endpoint");
        } else {
            log.error("Failed to submit metrics to Confluent via insecure endpoint={} -- giving up", (Object)this.endpointHttp);
        }
    }

    private boolean isSecureEndpointEnabled() {
        return !this.endpointHttps.isEmpty();
    }

    private boolean isInsecureEndpointEnabled() {
        return !this.endpointHttp.isEmpty();
    }

    String getEndpointHttp() {
        return this.endpointHttp;
    }

    String getEndpointHttps() {
        return this.endpointHttps;
    }

    private boolean submittedSuccessfully(int statusCode) {
        return statusCode == 200;
    }

    private int sendSecurely(byte[] encodedMetricsRecord) {
        return this.send(encodedMetricsRecord, this.endpointHttps);
    }

    private int sendInsecurely(byte[] encodedMetricsRecord) {
        return this.send(encodedMetricsRecord, this.endpointHttp);
    }

    private int send(byte[] encodedMetricsRecord, String endpoint) {
        return WebClient.send(this.customerId, encodedMetricsRecord, new HttpPost(endpoint), this.proxy, this.responseHandler);
    }
}

