/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.licenses;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import io.confluent.licenses.JarUtils;
import io.confluent.licenses.LicenseCache;
import io.confluent.licenses.LicenseEntry;
import io.confluent.licenses.LicenseTable;
import io.confluent.licenses.LicenseTableRow;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NotDirectoryException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LicenseFinder {
    public static FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.getName().startsWith(".") && file.isDirectory();
        }
    };
    static final String JAR_FOLDER_OPT = "jar-folder";
    static final String OVERRIDE_FOLDER_OPT = "override-folder";
    static final String LICENSE_FOLDER_OPT = "license-folder";
    static final String NOTICE_FOLDER_OPT = "notice-folder";
    static final String JS_FOLDER_OPT = "javascript-folder";
    static final String HTML_FILE_OPT = "html-file";
    static final String FORCE_OPT = "force";
    static final String TITLE_OPTION = "title";
    static final String IGNORE_OPTION = "ignore";
    public static LicenseCache licenseCache = new LicenseCache();

    public static void main(String[] args) throws Exception {
        String outputNoticeFolderName;
        File noticeOutDir;
        Options options = new Options();
        options.addOption("i", JAR_FOLDER_OPT, true, "folder containing jar files");
        options.addOption("o", OVERRIDE_FOLDER_OPT, true, "folder containing override license files");
        options.addOption("l", LICENSE_FOLDER_OPT, true, "output folder for license files");
        options.addOption("n", NOTICE_FOLDER_OPT, true, "output folder for notice files");
        options.addOption("s", JS_FOLDER_OPT, true, "folder containing javascript files");
        options.addOption("h", HTML_FILE_OPT, true, "path to html file");
        options.addOption("f", FORCE_OPT, false, "force creation of new output directories (even if non-empty)");
        options.addOption("t", TITLE_OPTION, true, "title for html file");
        options.addOption("x", IGNORE_OPTION, true, "comma separated list of jars to ignore");
        options.getOption(JAR_FOLDER_OPT).setRequired(true);
        options.getOption(OVERRIDE_FOLDER_OPT).setRequired(false);
        options.getOption(LICENSE_FOLDER_OPT).setRequired(true);
        options.getOption(NOTICE_FOLDER_OPT).setRequired(true);
        options.getOption(HTML_FILE_OPT).setRequired(true);
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        Boolean forceOverwrite = cmd.hasOption(FORCE_OPT);
        String outputLicenseFolderName = cmd.getOptionValue(LICENSE_FOLDER_OPT).trim();
        File licenseOutDir = new File(outputLicenseFolderName);
        if (licenseOutDir.exists() && !forceOverwrite.booleanValue()) {
            if (forceOverwrite.booleanValue()) {
                for (File file : licenseOutDir.listFiles()) {
                    file.delete();
                }
                licenseOutDir.delete();
            } else {
                throw new FileAlreadyExistsException("License output directory exists: " + outputLicenseFolderName);
            }
        }
        licenseOutDir.mkdirs();
        HashSet overrides = Sets.newHashSet();
        if (cmd.hasOption(OVERRIDE_FOLDER_OPT)) {
            String overrideFolderName = cmd.getOptionValue(OVERRIDE_FOLDER_OPT).trim();
            File overrideDir = new File(overrideFolderName);
            if (!overrideDir.exists()) {
                throw new FileNotFoundException("Could not find override directory: " + overrideDir.toString());
            }
            if (!overrideDir.isDirectory()) {
                throw new NotDirectoryException("Not a directory: " + overrideFolderName);
            }
            if (overrideDir.exists()) {
                for (File f : overrideDir.listFiles()) {
                    if (!f.getName().startsWith("LICENSE-")) continue;
                    String name = f.getName().substring(8, f.getName().length() - 4);
                    File newFile = new File(outputLicenseFolderName, f.getName());
                    if (!newFile.toPath().equals(f.toPath())) {
                        FileUtils.copyFile((File)f, (File)newFile);
                    }
                    overrides.add(name);
                }
            }
        }
        if ((noticeOutDir = new File(outputNoticeFolderName = cmd.getOptionValue(NOTICE_FOLDER_OPT).trim())).exists()) {
            if (forceOverwrite.booleanValue()) {
                for (File f : noticeOutDir.listFiles()) {
                    f.delete();
                }
                noticeOutDir.delete();
            } else {
                throw new FileAlreadyExistsException("Notice output directory exists: " + outputNoticeFolderName);
            }
        }
        noticeOutDir.mkdirs();
        String string = cmd.getOptionValue(HTML_FILE_OPT).trim();
        File outputSummaryFile = new File(string);
        if (outputSummaryFile.exists()) {
            if (forceOverwrite.booleanValue()) {
                outputSummaryFile.delete();
            } else {
                throw new FileAlreadyExistsException("Output file exists: " + string);
            }
        }
        PrintStream outputSummaryFilePrintStream = new PrintStream(outputSummaryFile);
        String title = cmd.getOptionValue(TITLE_OPTION, "License Report");
        HashSet toIgnore = Sets.newHashSet();
        if (cmd.hasOption(IGNORE_OPTION)) {
            String toIgnoreString = cmd.getOptionValue(IGNORE_OPTION);
            for (String item : toIgnoreString.split(",")) {
                toIgnore.add(item);
            }
        }
        LicenseTable licenseTable = new LicenseTable(title);
        if (cmd.hasOption(JAR_FOLDER_OPT)) {
            String inputJarFolderName = cmd.getOptionValue(JAR_FOLDER_OPT).trim();
            File jarDir = new File(inputJarFolderName);
            if (!jarDir.exists()) {
                throw new FileNotFoundException("Could not find jar directory: " + jarDir.toString());
            }
            if (!jarDir.isDirectory()) {
                throw new NotDirectoryException("Not a directory: " + inputJarFolderName);
            }
            LicenseFinder.processJarFiles(licenseTable, jarDir, licenseOutDir, noticeOutDir, overrides, toIgnore);
        }
        if (cmd.hasOption(JS_FOLDER_OPT)) {
            String inputJavascriptFolderName = cmd.getOptionValue(JS_FOLDER_OPT).trim();
            LicenseFinder.processJsFiles(licenseTable, inputJavascriptFolderName, licenseOutDir, noticeOutDir, overrides, toIgnore);
        }
        licenseTable.printTable(outputSummaryFilePrintStream, licenseOutDir, outputSummaryFile);
        outputSummaryFilePrintStream.flush();
        outputSummaryFilePrintStream.close();
    }

    static void processJarFiles(LicenseTable licenseTable, File jarDir, File licenseOutDir, File noticeOutDir, Set<String> overrides, final Set<String> toIgnore) throws Exception {
        FilenameFilter jarFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar") && !toIgnore.contains(name);
            }
        };
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        for (File file : jarDir.listFiles(jarFilter)) {
            try {
                LicenseTableRow licenseTableRow = new LicenseTableRow();
                licenseTable.addLicense(licenseTableRow);
                licenseTableRow.setType("jar");
                String fileNameWithoutExtension = file.getName().substring(0, file.getName().length() - 4);
                licenseTableRow.setArtifactName(fileNameWithoutExtension);
                if (overrides.contains(fileNameWithoutExtension)) {
                    licenseTableRow.setHasLicenseFile(true);
                    continue;
                }
                JarArchiveInputStream jarArchiveInputStream = new JarArchiveInputStream((InputStream)FileUtils.openInputStream((File)file));
                JarArchiveEntry jarArchiveEntry = jarArchiveInputStream.getNextJarEntry();
                while (jarArchiveEntry != null) {
                    if (jarArchiveEntry.getName().toUpperCase().contains("LICENSE")) {
                        licenseTableRow.setLicenseText(JarUtils.contentReader(jarArchiveInputStream, jarArchiveEntry));
                        licenseTableRow.setHasLicenseFile(licenseTableRow.getLicenseText() != null);
                        licenseTableRow.setSource("included file");
                    } else if (jarArchiveEntry.getName().endsWith("NOTICE")) {
                        licenseTableRow.setNoticeText(JarUtils.contentReader(jarArchiveInputStream, jarArchiveEntry));
                    } else if (jarArchiveEntry.getName().endsWith(".pom") || jarArchiveEntry.getName().endsWith("pom.xml")) {
                        NodeList artifactIds;
                        Document document;
                        File pom = JarUtils.contentToFile(jarArchiveInputStream, jarArchiveEntry);
                        try {
                            document = documentBuilder.parse(pom);
                        }
                        catch (Exception e) {
                            System.err.printf("error processing %s\n", file.toString());
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                        NodeList urls = document.getElementsByTagName("url");
                        if (urls.getLength() > 0) {
                            licenseTableRow.setUrl(urls.item(0).getTextContent());
                        }
                        NodeList versions = document.getElementsByTagName("version");
                        licenseTableRow.setVersion(JarUtils.bestGuessFromNodeList(versions));
                        NodeList groupIds = document.getElementsByTagName("groupId");
                        if (groupIds.getLength() > 0) {
                            licenseTableRow.setGroupId(JarUtils.bestGuessFromNodeList(groupIds));
                        }
                        if ((artifactIds = document.getElementsByTagName("artifactId")).getLength() > 0) {
                            licenseTableRow.setArtifactId(JarUtils.bestGuessFromNodeList(artifactIds));
                        }
                        NodeList licenses = document.getElementsByTagName("license");
                        for (int i = 0; i < licenses.getLength(); ++i) {
                            Node license = licenses.item(i);
                            NodeList children = license.getChildNodes();
                            LicenseEntry licenseEntry = new LicenseEntry();
                            for (int j = 0; j < children.getLength(); ++j) {
                                Node child = children.item(j);
                                if (child.getNodeName().equals("name")) {
                                    licenseEntry.setName(child.getTextContent());
                                }
                                if (child.getNodeName().equals("distribution")) {
                                    licenseEntry.setDistribution(child.getTextContent());
                                }
                                if (child.getNodeName().equals("comments")) {
                                    licenseEntry.setComments(child.getTextContent());
                                }
                                if (!child.getNodeName().equals("url")) continue;
                                licenseEntry.setUrl(child.getTextContent());
                            }
                            licenseTableRow.addLicenseEntry(licenseEntry);
                            if (licenseEntry.getUrl() == "") continue;
                            licenseTableRow.setLicenseText(licenseCache.getLicense(licenseEntry.getUrl()));
                            licenseTableRow.setHasLicenseFile(licenseTableRow.getLicenseText() != null);
                            licenseTableRow.setSource(jarArchiveEntry.getName());
                        }
                        pom.delete();
                    } else if (jarArchiveEntry.getName().endsWith("MANIFEST.MF")) {
                        String manifest = JarUtils.contentReader(jarArchiveInputStream, jarArchiveEntry);
                        String[] lines = manifest.split("\n");
                        for (int i = 0; i < lines.length; ++i) {
                            String nextLine;
                            String line = lines[i];
                            if (line.startsWith("Bundle-Version: ")) {
                                String version = line.substring(16, line.length() - 1);
                                licenseTableRow.setVersion(version);
                                continue;
                            }
                            if (!line.startsWith("Bundle-License: ")) continue;
                            String content = line.substring(16, line.length() - 1);
                            if (i < lines.length && (nextLine = lines[i + 1]).startsWith(" ")) {
                                content = content + nextLine.trim();
                            }
                            LicenseEntry licenseEntry = new LicenseEntry();
                            if (content.startsWith("http")) {
                                licenseEntry.setUrl(content);
                            } else {
                                licenseEntry.setName(content);
                            }
                            licenseTableRow.addLicenseEntry(licenseEntry);
                            licenseTableRow.setSource(jarArchiveEntry.getName());
                        }
                    }
                    jarArchiveEntry = jarArchiveInputStream.getNextJarEntry();
                }
                licenseTableRow.writeLicenseFile(licenseOutDir);
                licenseTableRow.writeNoticeFile(noticeOutDir);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception("\nexception processing " + file.toString() + "\n", e);
            }
        }
    }

    static void processJsFiles(LicenseTable licenseTable, String inputJavascriptFolderName, File licenseOutDir, File noticeOutDir, Set<String> overrides, final Set<String> toIgnore) throws IOException {
        File jsDir = new File(inputJavascriptFolderName);
        if (!jsDir.exists()) {
            throw new FileNotFoundException("Could not find js directory: " + inputJavascriptFolderName);
        }
        ObjectMapper mapper = new ObjectMapper();
        ImmutableSet dependencies = Files.fileTreeTraverser().breadthFirstTraversal((Object)jsDir).filter((Predicate)new Predicate<File>(){

            public boolean apply(File input) {
                if (input.getAbsolutePath().contains("browser_field")) {
                    System.out.println("input path=" + input.getPath());
                }
                if (!"package.json".equals(input.getName())) {
                    return false;
                }
                for (String ignore : toIgnore) {
                    if (!input.getPath().endsWith(ignore)) continue;
                    return false;
                }
                return true;
            }
        }).transform((Function)new Function<File, File>(){

            public File apply(File input) {
                return input.getParentFile();
            }
        }).toSet();
        HashSet seenPackages = Sets.newHashSet();
        for (File project : dependencies) {
            String packageUrl;
            LicenseTableRow licenseTableRow = new LicenseTableRow();
            licenseTableRow.setArtifactName(project.getName());
            licenseTableRow.setType("js");
            File packageJson = new File(project, "package.json");
            Map packageFile = (Map)mapper.readValue(packageJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
            licenseTableRow.setArtifactName((String)packageFile.get("name"));
            licenseTableRow.setVersion((String)packageFile.get("version"));
            Boolean isPrivate = (Boolean)packageFile.get("private");
            isPrivate = isPrivate != null && isPrivate != false;
            if (licenseTableRow.getVersion() == null) {
                System.out.println("name=" + licenseTableRow.getArtifactName() + " is missing version info");
            }
            if (licenseTableRow.getArtifactName() == null || licenseTableRow.getArtifactName().trim().isEmpty() || isPrivate.booleanValue() || licenseTableRow.getVersion().contains("unreleasable") || !seenPackages.add(licenseTableRow.getArtifactName() + '-' + licenseTableRow.getVersion())) continue;
            licenseTable.addLicense(licenseTableRow);
            LicenseEntry licenseEntry = new LicenseEntry();
            Object license = packageFile.get("license");
            if (license != null) {
                if (license instanceof String) {
                    licenseEntry.setName((String)license);
                } else if (license instanceof Map) {
                    licenseEntry.setName((String)((Map)license).get("type"));
                    licenseEntry.setUrl((String)((Map)license).get("url"));
                }
                licenseTableRow.addLicenseEntry(licenseEntry);
            }
            if ((packageUrl = (String)packageFile.get("homepage")) == null) {
                Object repository = packageFile.get("repository");
                if (repository instanceof String) {
                    packageUrl = (String)repository;
                } else if (repository instanceof Map && (packageUrl = (String)((Map)repository).get("url")) != null && packageUrl.startsWith("git://")) {
                    packageUrl = packageUrl.replace("git://", "http://");
                }
            }
            licenseTableRow.setUrl(packageUrl);
            licenseTableRow.setSource("package.json");
            Object licensesObject = packageFile.get("licenses");
            if (licensesObject != null && licensesObject != null && licensesObject instanceof List) {
                List licenses = (List)licensesObject;
                for (Object o : licenses) {
                    if (!(o instanceof Map)) continue;
                    Map l = (Map)o;
                    String type = (String)l.get("type");
                    String url = (String)l.get("url");
                    if (type == null && url == null) continue;
                    licenseEntry.setName((String)l.get("type"));
                    licenseEntry.setUrl((String)l.get("url"));
                    licenseTableRow.addLicenseEntry(licenseEntry);
                }
            }
            if (overrides.contains(project.getName())) {
                licenseTableRow.setHasLicenseFile(true);
            } else {
                for (File file : project.listFiles()) {
                    if (file.getName().contains("LICENSE") || file.getName().contains("LICENCE")) {
                        licenseTableRow.setLicenseText(FileUtils.readFileToString((File)file));
                        licenseTableRow.setSource("included file");
                        licenseTableRow.setHasLicenseFile(true);
                        continue;
                    }
                    if (!file.getName().contains("NOTICE")) continue;
                    licenseTableRow.setNoticeText(FileUtils.readFileToString((File)file));
                }
            }
            licenseTableRow.writeLicenseFile(licenseOutDir);
            licenseTableRow.writeNoticeFile(noticeOutDir);
        }
    }
}

