/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.licenses;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import io.confluent.licenses.LicenseEntry;
import io.confluent.licenses.LicenseFinder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class LicenseTableRow
implements Comparable<LicenseTableRow> {
    private String type = null;
    private String artifactName = null;
    private String version = null;
    private String groupId = null;
    private String artifactId = null;
    private String url = null;
    private String licenseText = null;
    private String noticeText = null;
    private String source = null;
    private boolean hasLicenseFile = false;
    private Set<LicenseEntry> licenses = Sets.newHashSet();

    public Set<LicenseEntry> getLicenses() {
        return this.licenses;
    }

    public void setLicenses(Set<LicenseEntry> licenses) {
        this.licenses = licenses;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public String getNoticeText() {
        return this.noticeText;
    }

    public void setNoticeText(String noticeText) {
        this.noticeText = noticeText;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public void setArtifactName(String artifactName) {
        this.artifactName = artifactName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void addLicenseEntry(LicenseEntry licenseEntry) {
        this.licenses.add(licenseEntry);
    }

    public void printRow(PrintStream printStream, File licenseOutDir, File licenseFile) throws Exception {
        printStream.print("<TR>\n");
        if (this.getUrl() != null) {
            this.printLink(printStream, this.getArtifactName(), this.getUrl());
        } else {
            LicenseTableRow.printCell(printStream, this.getArtifactName());
        }
        LicenseTableRow.printCell(printStream, this.getType());
        LicenseTableRow.printCell(printStream, this.getVersion());
        printStream.print("<TD>");
        this.printLicenses(printStream);
        if (this.getSimpleLicenseSet().isEmpty() && this.getHasLicenseFile()) {
            File link = this.getLicenseFileLink(licenseOutDir);
            printStream.printf("<A HREF=\"%s\">%s</A>", licenseFile.toPath().getParent().relativize(link.toPath()).toString(), this.getSource() != null ? this.getSource() : link.getName());
        }
        printStream.print("</TD>");
        printStream.print("</TR>\n");
    }

    public static void printHeader(PrintStream printStream) {
        printStream.print("<THEAD>\n");
        printStream.print("<TR>\n");
        LicenseTableRow.printCell(printStream, "Artifact");
        LicenseTableRow.printCell(printStream, "Type");
        LicenseTableRow.printCell(printStream, "Version");
        LicenseTableRow.printCell(printStream, "License(s)");
        printStream.print("</TR>\n");
        printStream.print("</THEAD>\n");
    }

    private static void printCell(PrintStream printStream, String value) {
        printStream.printf("<TD>%s</TD>", value != null ? value : "");
    }

    private void printLicenses(PrintStream printStream) {
        for (LicenseEntry license : this.getSimpleLicenseSet()) {
            license.printEntry(printStream);
        }
    }

    private void printLink(PrintStream printStream, String name, String url) throws Exception {
        printStream.printf("<TD><A HREF=\"%s\">%s</A></TD>", url, name);
    }

    public File getLicenseFileLink(File licenseOutDir) {
        return this.getLicenseFileLink(licenseOutDir, null);
    }

    public File getLicenseFileLink(File licenseOutDir, Integer i) {
        if (i == null) {
            return new File(licenseOutDir, "LICENSE-" + this.getArtifactName() + ".txt");
        }
        return new File(licenseOutDir, "LICENSE-" + this.getArtifactName() + "-" + i.toString() + ".txt");
    }

    public void writeLicenseFile(File licenseOutDir) throws IOException {
        if (this.getLicenseText() != null) {
            FileUtils.writeStringToFile((File)this.getLicenseFileLink(licenseOutDir), (String)this.getLicenseText());
        } else if (!this.getLicenses().isEmpty()) {
            ArrayList licenses = Lists.newArrayList();
            for (LicenseEntry licenseEntry : this.getLicenses()) {
                String l = LicenseFinder.licenseCache.getLicense(licenseEntry.getUrl());
                if (l == null) continue;
                licenses.add(l);
            }
            if (licenses.size() == 1) {
                FileUtils.writeStringToFile((File)this.getLicenseFileLink(licenseOutDir), (String)((String)licenses.get(0)));
            } else {
                for (int i = 0; i < licenses.size(); ++i) {
                    FileUtils.writeStringToFile((File)this.getLicenseFileLink(licenseOutDir, i), (String)((String)licenses.get(i)));
                }
            }
        }
    }

    public void writeNoticeFile(File noticeOutDir) throws IOException {
        if (this.getNoticeText() != null) {
            FileUtils.writeStringToFile((File)new File(noticeOutDir, "NOTICE-" + this.getArtifactName() + ".txt"), (String)this.getNoticeText());
        }
    }

    public String toString() {
        StringBuffer toReturn = new StringBuffer();
        toReturn.append("LicenseTableRow{type='" + this.type + '\'' + ", artifactName='" + this.artifactName + '\'' + ", version='" + this.version + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", url='" + this.url + '\'' + ", licenseText='" + this.licenseText + '\'' + ", noticeText='" + this.noticeText + '\'' + ", source='" + this.source + '\'' + ", licenses=[");
        Iterator<LicenseEntry> licenseIterator = this.licenses.iterator();
        while (licenseIterator.hasNext()) {
            LicenseEntry license = licenseIterator.next();
            toReturn.append(license.toString());
            if (!licenseIterator.hasNext()) continue;
            toReturn.append(", ");
        }
        toReturn.append("]}");
        return toReturn.toString();
    }

    public Set<LicenseEntry> getSimpleLicenseSet() {
        HashSet simple = Sets.newHashSet();
        for (LicenseEntry licenseEntry : this.getLicenses()) {
            String name = licenseEntry.getName();
            String url = licenseEntry.getUrl();
            LicenseEntry simpleEntry = new LicenseEntry();
            if (name == null) {
                name = LicenseEntry.licenseUrlToNameMap.get(url);
                if (name == null) {
                    name = url != null ? "link from artifact (" + this.getSource() + ")" : null;
                }
            } else {
                name = LicenseEntry.standardizeLicenseName(name);
            }
            if (url == null) {
                url = LicenseEntry.licenseNameToUrlMap.get(name);
            }
            simpleEntry.setUrl(url);
            simpleEntry.setName(name);
            simple.add(simpleEntry);
        }
        return simple;
    }

    public void setHasLicenseFile(boolean b) {
        this.hasLicenseFile = b;
    }

    public boolean getHasLicenseFile() {
        return this.hasLicenseFile;
    }

    @Override
    public int compareTo(LicenseTableRow o) {
        return ComparisonChain.start().compare((Object)this.getGroupId(), (Object)o.getGroupId(), (Comparator)Ordering.natural().nullsLast()).compare((Object)this.getArtifactId(), (Object)o.getArtifactId(), (Comparator)Ordering.natural().nullsLast()).compare((Object)this.getArtifactName(), (Object)o.getArtifactName(), (Comparator)Ordering.natural().nullsLast()).compare((Object)this.getVersion(), (Object)o.getVersion(), (Comparator)Ordering.natural().nullsLast()).result();
    }
}

