/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.monitoring.clients.interceptor;

import io.confluent.shaded.com.google.common.collect.ImmutableMap;
import io.confluent.shaded.com.google.common.collect.Maps;
import io.confluent.shaded.monitoring.common.MonitoringProducerDefaults;
import io.confluent.shaded.monitoring.common.TimeBucket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class MonitoringInterceptorConfig
extends AbstractConfig {
    public static final String MONITORING_INTERCEPTOR_PREFIX = "confluent.monitoring.interceptor.";
    private static final ConfigDef config;
    public static final String TOPIC_CONFIG = "confluent.monitoring.interceptor.topic";
    public static final String DEFAULT_TOPIC_CONFIG = "_confluent-monitoring";
    public static final String TOPIC_CONFIG_DOC = "Topic on which monitoring data will be written.";
    public static final String PUBLISH_PERIOD = "confluent.monitoring.interceptor.publishMs";
    public static final Long DEFAULT_PUBLISH_PERIOD;
    public static final String PUBLISH_PERIOD_DOC = "Period the interceptor should use to publish messages to confluent.monitoring.interceptor.confluent.monitoring.interceptor.topic";

    public MonitoringInterceptorConfig(Properties props) {
        super(config, (Map)props);
    }

    public MonitoringInterceptorConfig(Map<String, ?> clientConfigs) {
        super(config, clientConfigs);
    }

    public static void main(String[] args) {
        System.out.println(config.toHtmlTable());
    }

    static MonitoringInterceptorConfig getConfig(Map<String, ?> clientConfigs) {
        return new MonitoringInterceptorConfig(clientConfigs);
    }

    static Map<String, Object> withPrefix(Map<String, ?> input, String prefix) {
        ImmutableMap.Builder<String, ?> out = ImmutableMap.builder();
        for (Map.Entry<String, ?> entry : input.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            out.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return out.build();
    }

    static Map<String, Object> getProducerProperties(Map<String, ?> clientConfigs) {
        HashMap<String, Object> out = Maps.newHashMap();
        out.putAll(MonitoringProducerDefaults.PRODUCER_CONFIG_DEFAULTS);
        out.putAll(MonitoringInterceptorConfig.withPrefix(clientConfigs, MONITORING_INTERCEPTOR_PREFIX));
        Object clientId = out.get("client.id");
        if (clientId == null && (clientId = clientConfigs.get("client.id")) != null) {
            out.put("client.id", MONITORING_INTERCEPTOR_PREFIX + clientId);
        }
        if (clientId == null) {
            throw new ConfigException("Expected client.id");
        }
        Object bootstrap = out.get("bootstrap.servers");
        if (bootstrap == null && (bootstrap = clientConfigs.get("bootstrap.servers")) != null) {
            out.put("bootstrap.servers", bootstrap);
        }
        if (bootstrap == null) {
            throw new ConfigException("Expected bootstrap.servers");
        }
        return Collections.unmodifiableMap(out);
    }

    static {
        DEFAULT_PUBLISH_PERIOD = TimeBucket.SIZE;
        config = new ConfigDef().define(TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_TOPIC_CONFIG, ConfigDef.Importance.HIGH, TOPIC_CONFIG_DOC).define(PUBLISH_PERIOD, ConfigDef.Type.LONG, (Object)DEFAULT_PUBLISH_PERIOD, ConfigDef.Importance.HIGH, PUBLISH_PERIOD_DOC);
    }
}

